/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*
import com.urbancode.air.plugin.scm.changelog.*

import java.util.Date;
import java.util.TimeZone;
import java.text.SimpleDateFormat


public class SCMQuietPeriod {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    File dir
    Date lastModifiedDate
    File lastModifiedFile
    
    /**
     *
     * @return date of the last change
     */
    public def execute() {
        getChangeHistory(dir)
        return lastModifiedDate
    }
        
    private void getChangeHistory(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles()
            for (int i = 0; i < fileArray.length; i++) {
                if (fileArray[i].isDirectory()) {
                    getChangeHistory(fileArray[i])
                }
                else {
                    Date lastModified = new Date(fileArray[i].lastModified())
                    if (lastModifiedDate == null || lastModifiedDate.before(lastModified)) {
                        lastModifiedDate = lastModified
                        lastModifiedFile = fileArray[i];
                    }
                }
            }
        }
    }
}
