final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def fromDir = props['sourceDir']
final def toDirs = props['destDirList']
final def includes = props['includes']
final def excludes = props['excludes']
final def mapperRules = props['mapperRules'];

if (!fromDir) { fromDir = workDir.canonicalPath }

def ant = new AntBuilder()
try {
    toDirs.eachLine {toDir ->
        if (toDir != null && toDir.trim().length() > 0) {
            ant.echo("Preparing Copy from " + fromDir + " to " + toDir)
            ant.copy(verbose: "true", todir: toDir, overwrite: "true") {
                fileset(dir: fromDir) {
                    includes.eachLine { includeRule ->
                        if (includeRule != null && includeRule.trim().length() > 0) {
                            include(name: includeRule.trim())
                        }
                    }
                    excludes?.eachLine { excludeRule ->
                        if (excludeRule != null && excludeRule.trim().length() > 0) {
                            exclude(name: excludeRule.trim())
                        }
                    }
                }
                if(mapperRules && mapperRules.trim().length() > 0) {
                    compositemapper() {
                        mapperRules.eachLine { mapRule ->
                            if (mapRule != null && mapRule.trim().length() > 0) {
                                def rules = mapRule.split("->", 2);
                                if(rules.length != 2) {
                                    throw new IllegalArgumentException('The mapper rule "' + mapRule + '" is not valid.');
                                }

                                for(int i = 0; i < rules.length; i++) {
                                    if(rules[i].count("*") > 1) {
                                        throw new IllegalArgumentException('The mapping rule "' + rules[i] + '" cannot contain more than one *.');
                                    }
                                }
                                globmapper(from: rules[0].trim(), to: rules[1].trim());
                            }
                        }
                        globmapper(from: "*", to: "*");
                    }
                }
            }
        }
    }
}
catch (Exception e) {
    println "Error copying directory: ${e.message}"
    System.exit(1)
}

System.exit(0)

