import com.urbancode.air.AirPluginTool
import java.util.Properties

def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
final def props = apTool.getStepProperties()
final def inputPropsFile = new File(args[0])

def dirOffset = props['dir']
def fileName = props['file']

if (dirOffset) {
    workDir = new File(workDir, dirOffset).canonicalFile
}

def propFile = new File(workDir, fileName)

println "Working directory: ${workDir.canonicalPath}"
println "Property File: ${propFile.canonicalPath}"

try {
    def loadedProps = new Properties()
    loadedProps.load(new File(propFile.canonicalPath).newInputStream())
    loadedProps.each{ cur ->
        apTool.setOutputProperty(cur.key, cur.value)
    }
}
catch (Exception e) {
    println "Error reading property file ${propFile.canonicalPath}: ${e.message}"
    System.exit(1)
}
apTool.setOutputProperties()
System.exit(0)
