final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def dirOffset = props['dir']
def fileName = props['file']
def updateProps = props['updateProps']
def deleteProps = props['deleteProps']

if (dirOffset) {
    workDir = new File(workDir, dirOffset).canonicalFile
}

def propFile = new File(workDir, fileName)

println "Working directory: ${workDir.canonicalPath}"
println "Property File: ${propFile.canonicalPath}"
println "Update Properties:\n${updateProps?:''}\n"
println "Delete Properties:\n${deleteProps?:''}\n"

def ant = new AntBuilder()
try {
    if (updateProps?.trim().size() > 0 || deleteProps?.trim().size() > 0) {
        ant.propertyfile(file: propFile.canonicalPath) {
            updateProps?.trim().split('\n').each {
                def index = it?.trim().indexOf('=')
                if (it && index != -1) {
                    entry(key:it.trim().substring(0, index),
                          value: it.trim().substring(index + 1),
                          operation: '=')
                }
            }
            deleteProps?.trim().split('\n').each {
                if (it.trim().size() > 0) {
                    entry(key:it.trim(), operation: 'del')
                }
            }
        }
    }
}
catch (Exception e) {
    println "Error updating property file ${propFile.canonicalPath}: ${e.message}"
    System.exit(1)
}

System.exit(0)

