final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def includes = props['includes'];
final def excludes = props['excludes'];
def lineEnding = null;

if (props['lineEnding'] == 'os') {
   println "using os line endings"
   lineEnding = System.getProperty("line.separator");
}
else if (props['lineEnding'] == 'unix') {
   println "using unix line endings"
   lineEnding = "\n";
}
else {
   println "using windows line endings"
   lineEnding = "\r\n";
}

def ant = new AntBuilder();

def flip = { file ->
    File tempFile = File.createTempFile("temp", "file");
    file.eachLine { line ->
       tempFile.append(line);
       tempFile.append(lineEnding);
    }
    ant.copy(file:tempFile.getAbsolutePath(), tofile:file.getAbsolutePath(), overwrite:true);
    tempFile.delete();
}


def scanner = ant.fileScanner {
    fileset(dir:".") {
       for (def includeRule in includes.split("\n")) {
           include(name:includeRule);
       }
       for (def excludeRule in excludes.split("\n")) {
           exclude(name:excludeRule);
       }
    }
}

for (f in scanner) {
   System.out.println("Flipping line ending for file " + f.name);
   flip(f);
}
