/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import org.ini4j.Wini
import org.ini4j.Config

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def fileName = props['file']
final def add = props['add']
final def remove = props['remove']
final def addComments = props['addComments']
final def poundComments = props['poundComments']

def file = new File(fileName)
if (!file.exists()) file.createNewFile()

def ini = new Wini(file)
Config cfg = ini.getConfig()
cfg.setStrictOperator(true)
cfg.setEmptySection(true)

if (poundComments != null && poundComments.toBoolean() == true) {
    cfg.setCommentChar('#' as char)
}
else {
    cfg.setCommentChar(';' as char)
}

try {
    println "Updating file $file"
    add?.eachLine {
        if (it && it.trim().length() > 0 && it.indexOf('=') > -1) {
            def index = it.indexOf('=')
            def group
            def name = it.substring(0, index)
            def value = ''
            if (index < it.length() - 1) {
                value = it.substring(index + 1)
            }

            if (name.lastIndexOf('\\') != -1) {
                group = name.substring(0, name.lastIndexOf('\\'))
                name = name.substring(name.lastIndexOf('\\') + 1)
            }
            println "Setting $it"
            if (!group) throw new Exception("Could not detect group name in $it")

            ini.put(group, name, value)
        }
    }
    remove?.eachLine {
        if (it && it.trim().length() > 0) {
            println "Removing $it"
            def group
            def name = it
            if (name.lastIndexOf('\\') != -1) {
                group = name.substring(0, name.lastIndexOf('\\'))
                name = name.substring(name.lastIndexOf('\\') + 1)
            }

            if (!group) throw new Exception("Could not detect group name in $it")

            try {
                ini.get(group).remove(name)
            }
            catch (Exception ee) {
                // this is to prevent failing on non-existent values
            }
        }
    }
    addComments?.eachLine {
        def group
        def comment

        if (it && it.trim().length() > 0 && it.indexOf('=') > -1) {
            def indexOfEquals = it.indexOf('=')
            group = it.substring(0, indexOfEquals)
            comment = it.substring(indexOfEquals+1)
        }
        println "Adding Comment $it"
        if (!group) throw new Exception("Could not detect group name in $it")

        ini.putComment(group, comment)
    }
    ini.store()
}
catch (Exception e) {
    println "Error updating file $file: ${e.message}"
    System.exit(1)
}

System.exit(0)

