/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()


final def srcDirOffset = props['srcDirOffset']
final def destDirOffset = props['destDirOffset']
final def includes = props['includes']
final def excludes = props['excludes']
final def replaceText = props['replaceText']
final def setAttr = props['setAttr']
final def removeList = props['remove']
final def insertList = props['insert']
final def failWithoutMatch = props['failWithoutMatch']

def ant = new AntBuilder()

ant.taskdef(name:'xmltask', classname:'com.oopsconsultancy.xmltask.ant.XmlTask')

if (!srcDirOffset) {
    srcDirOffset = '.'
}

if (!destDirOffset) {
	destDirOffset = '.'
}

println "Working Directory: ${workDir}"
println "Source Directory Offset: ${srcDirOffset}"
println "Destination Directory Offset: ${destDirOffset}"
println "File Includes: ${includes}"
println "File Excludes: ${excludes}"
println "-----------------------------"

try {
    ant.xmltask(expandEntityReferences:'false',
            report:'false',
            failWithoutMatch:failWithoutMatch,
            toDir: new File(workDir, destDirOffset)) {
        fileset(dir:srcDirOffset) {
            includes.split('\n').each {
                if (it && it.trim().length() > 0) {
                    include(name:it.trim())
                }
            }
            
            if(excludes) {
                excludes.split('\n').each {
                    if (it && it.trim().length() > 0) {
                        exclude(name:it.trim())
                    }
    
                }
            }
        }
        
        if (replaceText) {
            replaceText.split('\n').each {
                if (it && it.trim().length() > 0) {
                    def index = it.indexOf('->')
                    if ( index > 0) {
                        println "Replace ${it[0..index - 1].trim()} with ${it[index + 2..-1]}"
                        replace(path:it[0..index - 1].trim(), withText:it[index + 2..-1], expandProperties:'false')
                    }
                    else {
                        println "Invalid replace text rule found: $it"
                        System.exit 1
                    }
                }
            }
        }
    
        if (insertList) {
            insertList.split('\n').each {
                if (it && it.trim().length() > 0) {
                    def index = it.indexOf('->')
                    if ( index > 0) {
                        println "Inserting\n${it[index + 2..-1]}\nunder ${it[0..index - 1].trim()}"
                        insert(
                                path:it[0..index - 1].trim(),
                                position:'under',
                                expandProperties:'false',
                                xml:it[index + 2..-1]) {
                        }
                    }
                    else {
                        println "Invalid insert rule found: $it"
                        System.exit 1
                    }
                }
            }
        }
    
        if (setAttr) {
            setAttr.split('\n').each {
                if (it && it.trim().length() > 0) {
                    def separatorIndex = it.indexOf('->')
                    def attributeIndex = it.indexOf('/@')
                    if ( separatorIndex > 0 && attributeIndex > 0) {
                        def element = it.substring(0, attributeIndex)
                        def attribute = it.substring(attributeIndex + 2, separatorIndex)
                        println "Set attribute $attribute on element $element to ${it[separatorIndex + 2..-1]}"
                        attr(path:element.trim(), attr: attribute.trim(), value:it[separatorIndex + 2..-1])
                    }
                    else {
                        println "Invalid replace text rule found: $it"
                        System.exit 1
                    }
                }
            }
        }
    
        if (removeList) {
            removeList.split('\n').each {
                if (it && it.trim().length() > 0) {
                    println "Removing ${it.trim()}"
                    remove(path:"${it.trim()}")
                }
            }
        }
    }
}
catch (Exception e) {
    e.printStackTrace()
    System.exit 1
}

System.exit(0)

