/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata.crypto;

import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import com.urbancode.air.securedata.crypto.CipherAlgorithmAES128;
import com.urbancode.air.securedata.crypto.CipherAlgorithmAES256;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.CryptoSuiteImpl;
import com.urbancode.air.securedata.crypto.CryptoTable;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import com.urbancode.air.securedata.crypto.MACAlgorithmSHA256;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public final class DefaultCryptoTable {
    public static final String AES128_HMACSHA256;
    public static final String AES256_HMACSHA256;
    private static CryptoTable defaultTable;
    static final CipherAlgorithmAES128 aes128;
    static final CipherAlgorithmAES256 aes256;
    static final MACAlgorithmSHA256 sha256;

    public static synchronized CryptoTable get() {
        return defaultTable;
    }

    public static synchronized CryptoTable set(CryptoTable table) {
        CryptoTable old = defaultTable;
        defaultTable = table;
        return old;
    }

    private DefaultCryptoTable() {
    }

    static {
        try {
            aes128 = new CipherAlgorithmAES128();
            aes256 = new CipherAlgorithmAES256();
            sha256 = new MACAlgorithmSHA256();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        final CryptoSuiteImpl aes128sha256 = new CryptoSuiteImpl(aes128, sha256);
        final CryptoSuiteImpl aes256sha256 = new CryptoSuiteImpl(aes256, sha256);
        AES128_HMACSHA256 = aes128sha256.getName();
        AES256_HMACSHA256 = aes256sha256.getName();
        defaultTable = new CryptoTable(){
            final Map<String, MACAlgorithm> macs = new HashMap<String, MACAlgorithm>();
            final Map<String, CipherAlgorithm> ciphers;
            final Map<String, CryptoSuite> suites;
            {
                this.macs.put(sha256.getName(), sha256);
                this.ciphers = new HashMap<String, CipherAlgorithm>();
                this.ciphers.put(aes128.getName(), aes128);
                this.ciphers.put(aes256.getName(), aes256);
                this.suites = new HashMap<String, CryptoSuite>();
                this.suites.put(AES128_HMACSHA256, aes128sha256);
                this.suites.put(AES256_HMACSHA256, aes256sha256);
            }

            public MACAlgorithm getMACAlgorithm(String algorithm) {
                return this.macs.get(algorithm);
            }

            public CipherAlgorithm getCipherAlgorithm(String algorithm) {
                return this.ciphers.get(algorithm);
            }

            public CryptoSuite getCryptoSuite(String suite) {
                return this.suites.get(suite);
            }
        };
    }
}

