/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool

AirPluginTool airTool = new AirPluginTool(args[0], args[1])
Properties props = airTool.getStepProperties()

def workDir = new File('.').canonicalFile

def fromDir  = props['sourceDir']
def toDirs   = props['destDirList']
def includes = props['includes']
def excludes = props['excludes']
def force    = props['force']
def flatten  = props['flatten']
def preserveLastModified = props['preserveLastModified']
def mapperRules = props['mapperRules']
String failOnError = props['failOnError']

if (!fromDir) { fromDir = workDir.canonicalPath }

def ant = new AntBuilder()
try {
    toDirs.eachLine {toDir ->
        if (toDir != null && toDir.trim().length() > 0) {
            ant.echo("Preparing Copy from " + fromDir + " to " + toDir)
            ant.copy(verbose: "true", todir: toDir, overwrite: "true", force: force,
                    flatten: flatten, preservelastmodified: preserveLastModified, failonerror: failOnError) {
                fileset(dir: fromDir) {
                    includes.eachLine { includeRule ->
                        if (includeRule != null && includeRule.trim().length() > 0) {
                            include(name: includeRule.trim())
                        }
                    }
                    excludes?.eachLine { excludeRule ->
                        if (excludeRule != null && excludeRule.trim().length() > 0) {
                            exclude(name: excludeRule.trim())
                        }
                    }
                }
                if(mapperRules && mapperRules.trim().length() > 0) {
                    compositemapper() {
                        mapperRules.eachLine { mapRule ->
                            if (mapRule != null && mapRule.trim().length() > 0) {
                                def rules = mapRule.split("->", 2);
                                if(rules.length != 2) {
                                    throw new IllegalArgumentException('The mapper rule "' + mapRule + '" is not valid.');
                                }

                                for(int i = 0; i < rules.length; i++) {
                                    if(rules[i].count("*") > 1) {
                                        throw new IllegalArgumentException('The mapping rule "' + rules[i] + '" cannot contain more than one *.');
                                    }
                                }
                                globmapper(from: rules[0].trim(), to: rules[1].trim());
                            }
                        }
                        globmapper(from: "*", to: "*");
                    }
                }
            }
        }
    }
}
catch (Exception e) {
    println "Error copying directory: ${e.message}"
    System.exit(1)
}

System.exit(0)
