/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.graph.AbstractGraph;
import edu.umd.cs.findbugs.util.NullIterator;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFG
extends AbstractGraph<Edge, BasicBlock>
implements Debug {
    public static final int PRUNED_INFEASIBLE_EXCEPTIONS = 1;
    public static final int PRUNED_UNCONDITIONAL_THROWERS = 2;
    public static final int REFINED = 4;
    public static final int PRUNED_FAILED_ASSERTION_EDGES = 8;
    public static final int BUSY = 16;
    public static final int FOUND_INEXACT_UNCONDITIONAL_THROWERS = 32;
    private BasicBlock entry;
    private BasicBlock exit;
    private int flags;
    private String methodName;
    private MethodGen methodGen;
    private List<Edge> removedEdgeList;

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setMethodGen(MethodGen methodGen) {
        this.methodGen = methodGen;
    }

    public MethodGen getMethodGen() {
        return this.methodGen;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSig() {
        return this.methodGen.getSignature();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setFlag(int flags) {
        this.flags |= flags;
    }

    public void clearFlag(int flags) {
        this.flags &= ~flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public BasicBlock getEntry() {
        if (this.entry == null) {
            this.entry = this.allocate();
        }
        return this.entry;
    }

    public BasicBlock getExit() {
        if (this.exit == null) {
            this.exit = this.allocate();
        }
        return this.exit;
    }

    public Edge createEdge(BasicBlock source, BasicBlock dest, @Edge.Type int type) {
        Edge edge = (Edge)this.createEdge(source, dest);
        edge.setType(type);
        return edge;
    }

    public Edge lookupEdgeById(int id) {
        Iterator i = this.edgeIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            if (edge.getId() != id) continue;
            return edge;
        }
        return null;
    }

    public BasicBlock lookupBlockByLabel(int blockLabel) {
        Iterator<BasicBlock> i = this.blockIterator();
        while (i.hasNext()) {
            BasicBlock basicBlock = i.next();
            if (basicBlock.getLabel() != blockLabel) continue;
            return basicBlock;
        }
        return null;
    }

    public Iterator<BasicBlock> blockIterator() {
        return this.vertexIterator();
    }

    public Iterable<BasicBlock> blocks() {
        return this.vertices();
    }

    public Iterator<Location> locationIterator() {
        return new LocationIterator();
    }

    public Iterable<Location> locations() {
        return new Iterable<Location>(){

            @Override
            public Iterator<Location> iterator() {
                return CFG.this.locationIterator();
            }
        };
    }

    public Collection<Location> orderedLocations() {
        TreeSet<Location> tree = new TreeSet<Location>();
        Iterator<Location> locs = this.locationIterator();
        while (locs.hasNext()) {
            Location loc = locs.next();
            tree.add(loc);
        }
        return tree;
    }

    public Collection<BasicBlock> getBlocks(BitSet labelSet) {
        LinkedList<BasicBlock> result = new LinkedList<BasicBlock>();
        Iterator<BasicBlock> i = this.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            if (!labelSet.get(block.getLabel())) continue;
            result.add(block);
        }
        return result;
    }

    public Collection<BasicBlock> getBlocksContainingInstructionWithOffset(int offset) {
        LinkedList<BasicBlock> result = new LinkedList<BasicBlock>();
        Iterator<BasicBlock> i = this.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            if (!block.containsInstructionWithOffset(offset)) continue;
            result.add(block);
        }
        return result;
    }

    public Collection<Location> getLocationsContainingInstructionWithOffset(int offset) {
        LinkedList<Location> result = new LinkedList<Location>();
        Iterator<Location> i = this.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            if (location.getHandle().getPosition() != offset) continue;
            result.add(location);
        }
        return result;
    }

    public BasicBlock getPredecessorWithEdgeType(BasicBlock target, @Edge.Type int edgeType) {
        Edge edge = this.getIncomingEdgeWithType(target, edgeType);
        return edge != null ? (BasicBlock)edge.getSource() : null;
    }

    public BasicBlock getSuccessorWithEdgeType(BasicBlock source, @Edge.Type int edgeType) {
        Edge edge = this.getOutgoingEdgeWithType(source, edgeType);
        return edge != null ? (BasicBlock)edge.getTarget() : null;
    }

    public Location getExceptionThrowerLocation(Edge exceptionEdge) {
        BasicBlock basicBlock;
        if (!exceptionEdge.isExceptionEdge()) {
            throw new IllegalArgumentException();
        }
        InstructionHandle handle = ((BasicBlock)exceptionEdge.getSource()).getExceptionThrower();
        if (handle == null) {
            throw new IllegalStateException();
        }
        BasicBlock basicBlock2 = basicBlock = handle.getInstruction() instanceof ATHROW ? (BasicBlock)exceptionEdge.getSource() : this.getSuccessorWithEdgeType((BasicBlock)exceptionEdge.getSource(), 0);
        if (basicBlock == null && this.removedEdgeList != null) {
            for (Edge removedEdge : this.removedEdgeList) {
                if (removedEdge.getType() != 0 || removedEdge.getSource() != exceptionEdge.getSource()) continue;
                basicBlock = (BasicBlock)removedEdge.getTarget();
                break;
            }
        }
        if (basicBlock == null) {
            throw new IllegalStateException("No basic block for thrower " + handle + " in " + this.methodGen.getClassName() + "." + this.methodName + " : " + this.methodGen.getSignature());
        }
        return new Location(handle, basicBlock);
    }

    public Iterator<Edge> removedEdgeIterator() {
        return this.removedEdgeList != null ? this.removedEdgeList.iterator() : new NullIterator();
    }

    public Edge getIncomingEdgeWithType(BasicBlock basicBlock, @Edge.Type int edgeType) {
        return this.getEdgeWithType(this.incomingEdgeIterator(basicBlock), edgeType);
    }

    public Edge getOutgoingEdgeWithType(BasicBlock basicBlock, @Edge.Type int edgeType) {
        return this.getEdgeWithType(this.outgoingEdgeIterator(basicBlock), edgeType);
    }

    private Edge getEdgeWithType(Iterator<Edge> iter, @Edge.Type int edgeType) {
        while (iter.hasNext()) {
            Edge edge = iter.next();
            if (edge.getType() != edgeType) continue;
            return edge;
        }
        return null;
    }

    public BasicBlock allocate() {
        BasicBlock b = new BasicBlock();
        this.addVertex(b);
        return b;
    }

    public int getNumBasicBlocks() {
        return this.getNumVertices();
    }

    public int getMaxEdgeId() {
        return this.getNumEdgeLabels();
    }

    public void checkIntegrity() {
        Iterator<BasicBlock> i = this.blockIterator();
        while (i.hasNext()) {
            BasicBlock basicBlock = i.next();
            InstructionHandle prev = null;
            BasicBlock.InstructionIterator j = basicBlock.instructionIterator();
            while (j.hasNext()) {
                InstructionHandle handle = (InstructionHandle)j.next();
                if (prev != null && prev.getNext() != handle) {
                    throw new IllegalStateException("Non-consecutive instructions in block " + basicBlock.getLabel() + ": prev=" + prev + ", handle=" + handle);
                }
                prev = handle;
            }
        }
    }

    @Override
    protected Edge allocateEdge(BasicBlock source, BasicBlock target) {
        return new Edge(source, target);
    }

    @Override
    public void removeEdge(Edge edge) {
        super.removeEdge(edge);
        if (this.removedEdgeList == null) {
            this.removedEdgeList = new LinkedList<Edge>();
        }
        this.removedEdgeList.add(edge);
    }

    public int getNumNonExceptionSucessors(BasicBlock block) {
        int numNonExceptionSuccessors = block.getNumNonExceptionSuccessors();
        if (numNonExceptionSuccessors < 0) {
            numNonExceptionSuccessors = 0;
            Iterator i = this.outgoingEdgeIterator(block);
            while (i.hasNext()) {
                Edge edge = (Edge)i.next();
                if (edge.isExceptionEdge()) continue;
                ++numNonExceptionSuccessors;
            }
            block.setNumNonExceptionSuccessors(numNonExceptionSuccessors);
        }
        return numNonExceptionSuccessors;
    }

    public Location getLocationAtEntry() {
        InstructionHandle handle = this.getEntry().getFirstInstruction();
        assert (handle != null);
        return new Location(handle, this.getEntry());
    }

    public Location getPreviousLocation(Location loc) {
        InstructionHandle handle = loc.getHandle();
        BasicBlock basicBlock = loc.getBasicBlock();
        if (basicBlock.getFirstInstruction().equals(handle)) {
            BasicBlock prevBlock = basicBlock;
            do {
                if ((prevBlock = this.getPredecessorWithEdgeType(prevBlock, 0)) != null) continue;
                return loc;
            } while ((handle = prevBlock.getLastInstruction()) == null);
            return new Location(handle, prevBlock);
        }
        handle = handle.getPrev();
        return new Location(handle, basicBlock);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocationIterator
    implements Iterator<Location> {
        private Iterator<BasicBlock> blockIter;
        private BasicBlock curBlock;
        private Iterator<InstructionHandle> instructionIter;
        private Location next;

        private LocationIterator() {
            this.blockIter = CFG.this.blockIterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public Location next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Location result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.next == null) {
                if (this.instructionIter == null) {
                    if (!this.blockIter.hasNext()) {
                        return;
                    }
                    this.curBlock = this.blockIter.next();
                    this.instructionIter = this.curBlock.instructionIterator();
                }
                if (this.instructionIter.hasNext()) {
                    this.next = new Location(this.instructionIter.next(), this.curBlock);
                    continue;
                }
                this.instructionIter = null;
            }
        }
    }
}

