/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.MethodHash;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHash
implements XMLWriteable,
Comparable<ClassHash> {
    public static final String CLASS_HASH_ELEMENT_NAME = "ClassHash";
    public static final String METHOD_HASH_ELEMENT_NAME = "MethodHash";
    private String className;
    private byte[] classHash;
    private Map<XMethod, MethodHash> methodHashMap = new HashMap<XMethod, MethodHash>();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ClassHash() {
    }

    public ClassHash(String className, byte[] classHash) {
        this();
        this.className = className;
        this.classHash = new byte[classHash.length];
        System.arraycopy(classHash, 0, this.classHash, 0, classHash.length);
    }

    public void setMethodHash(XMethod method, byte[] methodHash) {
        this.methodHashMap.put(method, new MethodHash(method.getName(), method.getSignature(), method.isStatic(), methodHash));
    }

    public String getClassName() {
        return this.className;
    }

    public byte[] getClassHash() {
        return this.classHash;
    }

    public void setClassHash(byte[] classHash) {
        this.classHash = new byte[classHash.length];
        System.arraycopy(classHash, 0, this.classHash, 0, classHash.length);
    }

    public MethodHash getMethodHash(XMethod method) {
        return this.methodHashMap.get(method);
    }

    public ClassHash computeHash(JavaClass javaClass) {
        this.className = javaClass.getClassName();
        Method[] methodList = new Method[javaClass.getMethods().length];
        System.arraycopy(javaClass.getMethods(), 0, methodList, 0, javaClass.getMethods().length);
        Arrays.sort(methodList, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getSignature().compareTo(o2.getSignature());
            }
        });
        Field[] fieldList = new Field[javaClass.getFields().length];
        System.arraycopy(javaClass.getFields(), 0, fieldList, 0, javaClass.getFields().length);
        Arrays.sort(fieldList, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getSignature().compareTo(o2.getSignature());
            }
        });
        MessageDigest digest = Util.getMD5Digest();
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        for (Method method : methodList) {
            ClassHash.work(digest, method.getName(), encoder);
            ClassHash.work(digest, method.getSignature(), encoder);
            MethodHash methodHash = new MethodHash().computeHash(method);
            this.methodHashMap.put(XFactory.createXMethod(javaClass, method), methodHash);
        }
        for (Method method : fieldList) {
            ClassHash.work(digest, method.getName(), encoder);
            ClassHash.work(digest, method.getSignature(), encoder);
        }
        this.classHash = digest.digest();
        return this;
    }

    private static void work(MessageDigest digest, String s, CharsetEncoder encoder) {
        try {
            CharBuffer cbuf = CharBuffer.allocate(s.length());
            cbuf.put(s);
            cbuf.flip();
            ByteBuffer buf = encoder.encode(cbuf);
            int nbytes = buf.limit();
            byte[] encodedBytes = new byte[nbytes];
            buf.get(encodedBytes);
            digest.update(encodedBytes);
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag(CLASS_HASH_ELEMENT_NAME);
        xmlOutput.addAttribute("class", this.className);
        xmlOutput.addAttribute("value", ClassHash.hashToString(this.classHash));
        xmlOutput.stopTag(false);
        for (Map.Entry<XMethod, MethodHash> entry : this.methodHashMap.entrySet()) {
            xmlOutput.startTag(METHOD_HASH_ELEMENT_NAME);
            xmlOutput.addAttribute("name", entry.getKey().getName());
            xmlOutput.addAttribute("signature", entry.getKey().getSignature());
            xmlOutput.addAttribute("isStatic", String.valueOf(entry.getKey().isStatic()));
            xmlOutput.addAttribute("value", ClassHash.hashToString(entry.getValue().getMethodHash()));
            xmlOutput.stopTag(true);
        }
        xmlOutput.closeTag(CLASS_HASH_ELEMENT_NAME);
    }

    public static String hashToString(byte[] hash) {
        StringBuilder buf = new StringBuilder();
        for (byte b : hash) {
            buf.append(HEX_CHARS[b >> 4 & 0xF]);
            buf.append(HEX_CHARS[b & 0xF]);
        }
        return buf.toString();
    }

    private static int hexDigitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new IllegalArgumentException("Illegal hex character: " + c);
    }

    public static byte[] stringToHash(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hash string: " + s);
        }
        byte[] hash = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            byte b;
            hash[i / 2] = b = (byte)((ClassHash.hexDigitValue(s.charAt(i)) << 4) + ClassHash.hexDigitValue(s.charAt(i + 1)));
        }
        return hash;
    }

    public boolean isSameHash(ClassHash other) {
        return Arrays.equals(this.classHash, other.classHash);
    }

    public int hashCode() {
        if (this.classHash == null) {
            return 0;
        }
        int result = 1;
        for (byte element : this.classHash) {
            result = 31 * result + element;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassHash)) {
            return false;
        }
        return this.isSameHash((ClassHash)o);
    }

    @Override
    public int compareTo(ClassHash other) {
        int cmp = MethodHash.compareHashes(this.classHash, other.classHash);
        return cmp;
    }

    public String toString() {
        return this.getClassName() + ":" + ClassHash.hashToString(this.classHash);
    }
}

