/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGPrinter;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataflow<Fact, AnalysisType extends DataflowAnalysis<Fact>> {
    private CFG cfg;
    private AnalysisType analysis;
    private BlockOrder blockOrder;
    private boolean isForwards;
    private int numIterations;
    public static boolean DEBUG = SystemProperties.getBoolean("dataflow.debug");
    private static final int MAX_ITERS = SystemProperties.getInt("dataflow.maxiters", 97);

    public Dataflow(CFG cfg, AnalysisType analysis) {
        this.cfg = cfg;
        this.analysis = analysis;
        this.blockOrder = analysis.getBlockOrder(cfg);
        this.isForwards = analysis.isForwards();
        this.numIterations = 0;
        Iterator<BasicBlock> i = cfg.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            Object result = analysis.getResultFact(block);
            if (block == this.logicalEntryBlock()) {
                try {
                    analysis.initEntryFact(result);
                }
                catch (DataflowAnalysisException e) {
                    analysis.makeFactTop(result);
                }
                continue;
            }
            analysis.makeFactTop(result);
        }
    }

    private String getFullyQualifiedMethodName() {
        MethodGen methodGen = this.cfg.getMethodGen();
        String methodName = methodGen == null ? this.cfg.getMethodName() : SignatureConverter.convertMethodSignature(methodGen);
        return methodName;
    }

    public void execute() throws DataflowAnalysisException {
        boolean change;
        boolean sawBackEdge;
        boolean debugWas = DEBUG;
        if (DEBUG) {
            this.reportAnalysis("Executing");
        }
        int timestamp = 0;
        boolean firstTime = true;
        do {
            change = false;
            sawBackEdge = false;
            ++this.numIterations;
            if (this.numIterations > MAX_ITERS && !DEBUG) {
                DEBUG = true;
                this.reportAnalysis("Too many iterations");
                System.out.println(this.getClass().getName());
                if (this.getClass() == UnconditionalValueDerefDataflow.class || this.getClass() == LiveLocalStoreDataflow.class) {
                    try {
                        ClassContext cc = Global.getAnalysisCache().getClassAnalysis(ClassContext.class, DescriptorFactory.createClassDescriptorFromDottedClassName(this.cfg.getMethodGen().getClassName()));
                        System.out.println("Forwards cfg");
                        CFGPrinter printer = new CFGPrinter(this.cfg);
                        printer.setIsForwards(true);
                        printer.print(System.out);
                        System.out.println("Backwards cfg");
                        printer = new CFGPrinter(this.cfg);
                        printer.setIsForwards(false);
                        printer.print(System.out);
                        cc.dumpSimpleDataflowInformation(this.cfg.getMethodGen().getMethod());
                    }
                    catch (CheckedAnalysisException e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            if (DEBUG) {
                System.out.println("----------------------------------------------------------------------");
                System.out.println(this.getClass().getName() + " iteration: " + this.numIterations + ", timestamp: " + timestamp);
                MethodGen mg = this.cfg.getMethodGen();
                System.out.println(mg.getClassName() + "." + mg.getName() + mg.getSignature());
                System.out.println("----------------------------------------------------------------------");
            }
            if (this.numIterations >= MAX_ITERS + 9) {
                throw new AssertionError((Object)("Too many iterations (" + this.numIterations + ") in dataflow when analyzing " + this.getFullyQualifiedMethodName()));
            }
            this.analysis.startIteration();
            if (DEBUG && firstTime && this.blockOrder instanceof ReverseDFSOrder) {
                ReverseDFSOrder rBlockOrder = (ReverseDFSOrder)this.blockOrder;
                System.out.println("Entry point is: " + this.logicalEntryBlock());
                System.out.println("Basic block order: ");
                Iterator<BasicBlock> i = this.blockOrder.blockIterator();
                while (i.hasNext()) {
                    BasicBlock block = i.next();
                    Dataflow.debug(block, "rBlockOrder " + rBlockOrder.rdfs.getDiscoveryTime(block) + "\n");
                }
            }
            Iterator<BasicBlock> i = this.blockOrder.blockIterator();
            if (this.numIterations > 3 && this.numIterations % 2 == 0 && this.blockOrder instanceof ReverseDFSOrder) {
                if (DEBUG) {
                    System.out.println("Trying program order");
                }
                TreeSet<BasicBlock> bb = new TreeSet<BasicBlock>(new BackwardProgramOrder());
                Iterator<BasicBlock> j = this.blockOrder.blockIterator();
                while (j.hasNext()) {
                    BasicBlock block = j.next();
                    bb.add(block);
                }
                if (DEBUG) {
                    for (BasicBlock block : bb) {
                        Dataflow.debug(block, "\n");
                    }
                }
                i = bb.iterator();
            }
            if (DEBUG) {
                this.dumpDataflow(this.analysis);
            }
            while (i.hasNext()) {
                BasicBlock block = i.next();
                Object start = this.analysis.getStartFact(block);
                assert (start != null);
                boolean needToRecompute = false;
                Object result = this.analysis.getResultFact(block);
                assert (result != null);
                int originalResultTimestamp = this.analysis.getLastUpdateTimestamp(result);
                if (block == this.logicalEntryBlock()) {
                    this.analysis.makeFactTop(start);
                    this.analysis.initEntryFact(start);
                    if (DEBUG) {
                        Dataflow.debug(block, "Init entry fact ==> " + this.analysis.factToString(start) + "\n");
                    }
                    needToRecompute = true;
                } else {
                    BasicBlock logicalPred;
                    Edge edge;
                    int lastCalculated = this.analysis.getLastUpdateTimestamp(start);
                    Iterator<Edge> predEdgeIter = this.logicalPredecessorEdgeIterator(block);
                    int predCount = 0;
                    int rawPredCount = 0;
                    while (predEdgeIter.hasNext()) {
                        edge = predEdgeIter.next();
                        ++rawPredCount;
                        if (needToRecompute && (!firstTime || sawBackEdge)) continue;
                        logicalPred = this.isForwards ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
                        int direction = this.blockOrder.compare(block, logicalPred);
                        if (DEBUG) {
                            Dataflow.debug(block, "direction " + direction + " for " + Dataflow.blockId(logicalPred) + "\n");
                        }
                        if (direction < 0) {
                            sawBackEdge = true;
                        }
                        Object predFact = this.analysis.getResultFact(logicalPred);
                        int predLastUpdated = this.analysis.getLastUpdateTimestamp(predFact);
                        if (this.analysis.isTop(predFact)) continue;
                        ++predCount;
                        if (predLastUpdated < lastCalculated) continue;
                        needToRecompute = true;
                        if (!DEBUG) continue;
                        Dataflow.debug(block, "\n Need to recompute. My timestamp = " + lastCalculated + ", pred timestamp = " + predLastUpdated + ",\n   pred fact = " + predFact + "\n");
                    }
                    if (predCount == 0) {
                        needToRecompute = true;
                    }
                    if (!needToRecompute) continue;
                    if (needToRecompute) {
                        this.analysis.makeFactTop(start);
                        predEdgeIter = this.logicalPredecessorEdgeIterator(block);
                        while (predEdgeIter.hasNext()) {
                            edge = predEdgeIter.next();
                            logicalPred = this.isForwards ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
                            Object predFact = this.analysis.getResultFact(logicalPred);
                            Object edgeFact = this.analysis.createFact();
                            this.analysis.copy(predFact, edgeFact);
                            this.analysis.edgeTransfer(edge, edgeFact);
                            if (DEBUG && !this.analysis.same(edgeFact, predFact)) {
                                Dataflow.debug(block, logicalPred, edge, "Edge transfer " + this.analysis.factToString(predFact) + " ==> " + this.analysis.factToString(edgeFact));
                            }
                            if (DEBUG) {
                                if (this.analysis.isTop(start)) {
                                    Dataflow.debug(block, logicalPred, edge, "\n  First pred is " + this.analysis.factToString(edgeFact) + "\n   last updated at " + this.analysis.getLastUpdateTimestamp(predFact) + "\n");
                                } else {
                                    Dataflow.debug(block, logicalPred, edge, "\n  Meet " + this.analysis.factToString(start) + "\n   with " + this.analysis.factToString(edgeFact) + "\n   pred last updated at " + this.analysis.getLastUpdateTimestamp(predFact) + "\n");
                                }
                            }
                            if (this.analysis instanceof UnconditionalValueDerefAnalysis) {
                                ((UnconditionalValueDerefAnalysis)this.analysis).meetInto((UnconditionalValueDerefSet)edgeFact, edge, (UnconditionalValueDerefSet)start, rawPredCount == 1);
                            } else {
                                this.analysis.meetInto(edgeFact, edge, start);
                            }
                            this.analysis.setLastUpdateTimestamp(start, timestamp);
                            int pos = -1;
                            if (block.getFirstInstruction() != null) {
                                pos = block.getFirstInstruction().getPosition();
                            }
                            if (!DEBUG) continue;
                            System.out.println(" [" + pos + "]==> " + this.analysis.factToString(start) + " @ " + timestamp + " \n");
                        }
                    }
                }
                if (DEBUG) {
                    Dataflow.debug(block, "start fact is " + this.analysis.factToString(start) + "\n");
                }
                boolean resultWasTop = this.analysis.isTop(result);
                Object origResult = null;
                if (!resultWasTop) {
                    origResult = this.analysis.createFact();
                    this.analysis.copy(result, origResult);
                }
                this.analysis.transfer(block, null, start, result);
                if (DEBUG && SystemProperties.getBoolean("dataflow.blockdebug")) {
                    Dataflow.debug(block, "Dumping flow values for block:\n");
                    BasicBlock.InstructionIterator ii = block.instructionIterator();
                    while (ii.hasNext()) {
                        InstructionHandle handle = (InstructionHandle)ii.next();
                        Object tmpResult = this.analysis.createFact();
                        this.analysis.transfer(block, handle, start, tmpResult);
                        System.out.println("\t" + handle + " " + this.analysis.factToString(tmpResult));
                    }
                }
                if (DEBUG) {
                    Dataflow.debug(block, "orig result is " + (origResult == null ? "TOP" : this.analysis.factToString(origResult)) + "\n");
                }
                boolean thisResultChanged = false;
                if (resultWasTop) {
                    thisResultChanged = !this.analysis.isTop(result);
                } else {
                    boolean bl = thisResultChanged = !this.analysis.same(result, origResult);
                }
                if (thisResultChanged) {
                    ++timestamp;
                    if (DEBUG) {
                        Dataflow.debug(block, "result changed at timestamp " + timestamp + "\n");
                    }
                    if (DEBUG && !needToRecompute) {
                        System.out.println("I thought I didn't need to recompute");
                    }
                    change = true;
                    this.analysis.setLastUpdateTimestamp(result, timestamp);
                } else {
                    this.analysis.setLastUpdateTimestamp(result, originalResultTimestamp);
                }
                if (!DEBUG) continue;
                Dataflow.debug(block, "result is " + this.analysis.factToString(result) + " @ timestamp " + this.analysis.getLastUpdateTimestamp(result) + "\n");
            }
            this.analysis.finishIteration();
        } while (sawBackEdge && change);
        if (DEBUG) {
            System.out.println("-- Quiescence achieved-------------------------------------------------");
            System.out.println(this.getClass().getName() + " iteration: " + this.numIterations + ", timestamp: " + timestamp);
            MethodGen mg = this.cfg.getMethodGen();
            System.out.println(mg.getClassName() + "." + mg.getName() + mg.getSignature());
            new RuntimeException("Quiescence achieved----------------------------------------------------------------").printStackTrace(System.out);
        }
        DEBUG = debugWas;
    }

    private void reportAnalysis(String msg) {
        String shortAnalysisName = this.analysis.getClass().getName();
        int pkgEnd = shortAnalysisName.lastIndexOf(46);
        if (pkgEnd >= 0) {
            shortAnalysisName = shortAnalysisName.substring(pkgEnd + 1);
        }
        System.out.println(msg + " " + shortAnalysisName + " on " + this.getFullyQualifiedMethodName());
    }

    private static String blockId(BasicBlock bb) {
        InstructionHandle handle = bb.getFirstInstruction();
        if (handle == null) {
            return "" + bb.getLabel();
        }
        return bb.getLabel() + ":" + handle.getPosition() + " " + handle.getInstruction();
    }

    private static void debug(BasicBlock bb, String msg) {
        System.out.print("Dataflow (block " + Dataflow.blockId(bb) + "): " + msg);
    }

    private static void debug(BasicBlock bb, BasicBlock pred, Edge edge, String msg) {
        System.out.print("Dataflow (block " + Dataflow.blockId(bb) + ", predecessor " + Dataflow.blockId(pred) + " [" + Edge.edgeTypeToString(edge.getType()) + "]): " + msg);
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public Fact getStartFact(BasicBlock block) {
        return this.analysis.getStartFact(block);
    }

    public Fact getResultFact(BasicBlock block) {
        return this.analysis.getResultFact(block);
    }

    public Fact getFactAtLocation(Location location) throws DataflowAnalysisException {
        return this.analysis.getFactAtLocation(location);
    }

    public Fact getFactAfterLocation(Location location) throws DataflowAnalysisException {
        return this.analysis.getFactAfterLocation(location);
    }

    public Fact getFactOnEdge(Edge edge) throws DataflowAnalysisException {
        return this.analysis.getFactOnEdge(edge);
    }

    public AnalysisType getAnalysis() {
        return this.analysis;
    }

    public CFG getCFG() {
        return this.cfg;
    }

    private Iterator<Edge> logicalPredecessorEdgeIterator(BasicBlock block) {
        return this.isForwards ? this.cfg.incomingEdgeIterator(block) : this.cfg.outgoingEdgeIterator(block);
    }

    private BasicBlock logicalEntryBlock() {
        return this.isForwards ? this.cfg.getEntry() : this.cfg.getExit();
    }

    public void dumpDataflow(AnalysisType analysis) {
        System.out.println(this.getClass().getName() + " analysis for " + this.getCFG().getMethodName() + this.getCFG().getMethodSig() + " { ");
        try {
            for (Location loc : this.getCFG().orderedLocations()) {
                System.out.println("\nBefore: " + analysis.factToString(this.getFactAtLocation(loc)));
                System.out.println("Location: " + loc);
                System.out.println("After: " + analysis.factToString(this.getFactAfterLocation(loc)));
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("error dumping dataflow analysis", e);
            System.out.println(e);
        }
        System.out.println("}");
    }

    static class BackwardProgramOrder
    extends ForwardProgramOrder {
        BackwardProgramOrder() {
        }

        public int compare(BasicBlock o1, BasicBlock o2) {
            return super.compare(o2, o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForwardProgramOrder
    implements Comparator<BasicBlock>,
    Serializable {
        ForwardProgramOrder() {
        }

        @Override
        public int compare(BasicBlock o1, BasicBlock o2) {
            int p1 = o1.getLabel();
            int p2 = o2.getLabel();
            return p1 - p2;
        }
    }
}

