/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DefaultEncodingDetector
extends OpcodeStackDetector {
    private final BugAccumulator bugAccumulator;
    private final DefaultEncodingAnnotationDatabase defaultEncodingAnnotationDatabase;

    public DefaultEncodingDetector(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.defaultEncodingAnnotationDatabase = new DefaultEncodingAnnotationDatabase();
    }

    public boolean shouldVisit(JavaClass obj) {
        Set<ClassDescriptor> called = this.getXClass().getCalledClassDescriptors();
        for (ClassDescriptor c : this.defaultEncodingAnnotationDatabase.classes) {
            if (!called.contains(c)) continue;
            return true;
        }
        return false;
    }

    public void visit(Code code) {
        super.visit(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: {
                XMethod callSeen = XFactory.createXMethod(MethodAnnotation.fromCalledMethod(this));
                DefaultEncodingAnnotation annotation = (DefaultEncodingAnnotation)this.defaultEncodingAnnotationDatabase.getDirectAnnotation(callSeen);
                if (annotation == null) break;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DM_DEFAULT_ENCODING", 1).addClassAndMethod(this).addCalledMethod(this), this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultEncodingAnnotationDatabase
    extends AnnotationDatabase<DefaultEncodingAnnotation> {
        Set<ClassDescriptor> classes = new HashSet<ClassDescriptor>();

        public DefaultEncodingAnnotationDatabase() {
            this.setAddClassOnly(false);
            this.loadAuxiliaryAnnotations();
        }

        @Override
        protected void addMethodAnnotation(@DottedClassName String cName, String mName, String mSig, boolean isStatic, DefaultEncodingAnnotation annotation) {
            super.addMethodAnnotation(cName, mName, mSig, isStatic, annotation);
            this.classes.add(DescriptorFactory.createClassDescriptorFromDottedClassName(cName));
        }

        @Override
        public void loadAuxiliaryAnnotations() {
            this.addMethodAnnotation("java.lang.String", "getBytes", "()[B", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.lang.String", "<init>", "([B)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.lang.String", "<init>", "([BII)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.ByteArrayOutputStream", "toString", "()Ljava/lang/String;", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileReader", "<init>", "(Ljava/lang/String;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileReader", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileReader", "<init>", "(Ljava/io/FileDescriptor;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileWriter", "<init>", "(Ljava/lang/String;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileWriter", "<init>", "(Ljava/lang/String;Z)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileWriter", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileWriter", "<init>", "(Ljava/io/File;Z)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.FileWriter", "<init>", "(Ljava/io/FileDescriptor;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.InputStreamReader", "<init>", "(Ljava/io/InputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.OutputStreamWriter", "<init>", "(Ljava/io/OutputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintStream", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintStream", "<init>", "(Ljava/io/OutputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintStream", "<init>", "(Ljava/io/OutputStream;Z)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintStream", "<init>", "(Ljava/lang/String;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintWriter", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintWriter", "<init>", "(Ljava/io/OutputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintWriter", "<init>", "(Ljava/io/OutputStream;Z)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.io.PrintWriter", "<init>", "(Ljava/lang/String;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Scanner", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Scanner", "<init>", "(Ljava/io/InputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Scanner", "<init>", "(Ljava/nio/channels/ReadableByteChannel;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Formatter", "<init>", "(Ljava/lang/String;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Formatter", "<init>", "(Ljava/io/File;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
            this.addMethodAnnotation("java.util.Formatter", "<init>", "(Ljava/io/OutputStream;)V", false, DefaultEncodingAnnotation.DEFAULT_ENCODING);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultEncodingAnnotation
    extends AnnotationEnumeration<DefaultEncodingAnnotation> {
        public static final DefaultEncodingAnnotation DEFAULT_ENCODING = new DefaultEncodingAnnotation("DefaultEncoding", 1);
        private static final DefaultEncodingAnnotation[] myValues = new DefaultEncodingAnnotation[]{DEFAULT_ENCODING};

        public static DefaultEncodingAnnotation[] values() {
            return (DefaultEncodingAnnotation[])myValues.clone();
        }

        private DefaultEncodingAnnotation(String s, int i) {
            super(s, i);
        }
    }
}

