/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.Map;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteAnnotationRetention
extends AnnotationVisitor
implements Detector,
NonReportingDetector,
FirstPassDetector {
    private boolean runtimeRetention;

    public NoteAnnotationRetention(BugReporter bugReporter) {
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!annotationClass.equals("java.lang.annotation.Retention")) {
            return;
        }
        EnumElementValue v = (EnumElementValue)map.get("value");
        if ("RUNTIME".equals(v.getEnumValueString())) {
            this.runtimeRetention = true;
        }
    }

    @Override
    public void visit(JavaClass obj) {
        this.runtimeRetention = false;
    }

    @Override
    public void visitAfter(JavaClass obj) {
        for (String i : obj.getInterfaceNames()) {
            if (!i.equals("java.lang.annotation.Annotation")) continue;
            AnalysisContext.currentAnalysisContext().getAnnotationRetentionDatabase().setRuntimeRetention(this.getDottedClassName(), this.runtimeRetention);
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger(javaClass)) {
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void report() {
    }
}

