/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.interproc.MethodPropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.ParameterProperty;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Visitor;

public class TrainLongInstantfParams
extends PreorderVisitor
implements Detector,
TrainingDetector {
    LongInstantParameterDatabase database = new LongInstantParameterDatabase();

    public TrainLongInstantfParams(BugReporter bugReporter) {
    }

    public void visit(Code obj) {
        if (!this.getMethod().isPublic() && !this.getMethod().isProtected()) {
            return;
        }
        SignatureParser p = new SignatureParser(this.getMethodSig());
        LocalVariableTable t = obj.getLocalVariableTable();
        if (t == null) {
            return;
        }
        ParameterProperty property = new ParameterProperty();
        int index = this.getMethod().isStatic() ? 0 : 1;
        int parameterNumber = 0;
        Iterator<String> i = p.parameterSignatureIterator();
        while (i.hasNext()) {
            String s = i.next();
            LocalVariable localVariable = t.getLocalVariable(index, 0);
            if (localVariable != null) {
                String name = localVariable.getName();
                if (s.equals("J") && (name.toLowerCase().indexOf("instant") >= 0 || name.startsWith("date"))) {
                    property.setParamWithProperty(parameterNumber, true);
                }
            }
            index = s.equals("J") || s.equals("D") ? (index += 2) : ++index;
            ++parameterNumber;
        }
        if (!property.isEmpty()) {
            this.database.setProperty(this.getMethodDescriptor(), property);
        }
    }

    public void report() {
        AnalysisContext.currentAnalysisContext().storePropertyDatabase(this.database, "longInstant.db", "long instant database");
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongInstantParameterDatabase
    extends MethodPropertyDatabase<ParameterProperty> {
        LongInstantParameterDatabase() {
        }

        @Override
        protected ParameterProperty decodeProperty(String propStr) throws PropertyDatabaseFormatException {
            try {
                int longInstants = Integer.parseInt(propStr);
                ParameterProperty prop = new ParameterProperty(longInstants);
                return prop;
            }
            catch (NumberFormatException e) {
                throw new PropertyDatabaseFormatException("Invalid unconditional deref param set: " + propStr);
            }
        }

        @Override
        protected String encodeProperty(ParameterProperty property) {
            return String.valueOf(property.getParamsWithProperty());
        }
    }
}

