/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.util.Util;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

public class NameMatch {
    @CheckForNull
    private String spec;
    @CheckForNull
    private String exact;
    @CheckForNull
    private Pattern pattern;

    public int hashCode() {
        if (this.spec == null) {
            return 0;
        }
        return this.spec.hashCode();
    }

    public boolean isUniversal() {
        if (this.spec == null) {
            return true;
        }
        return this.spec.equals("~.*");
    }

    public boolean equals(Object o) {
        if (!(o instanceof NameMatch)) {
            return false;
        }
        return Util.nullSafeEquals(this.spec, ((NameMatch)o).spec);
    }

    public String getValue() {
        if (this.exact != null) {
            return this.exact;
        }
        if (this.pattern != null) {
            return this.pattern.toString();
        }
        return "~.*";
    }

    public NameMatch(String matchSpec) {
        this.spec = matchSpec;
        if (matchSpec != null) {
            if (matchSpec.startsWith("~")) {
                this.pattern = Pattern.compile(matchSpec.substring(1));
            } else {
                this.exact = matchSpec;
            }
        }
    }

    public boolean match(String value) {
        if (this.exact != null) {
            return this.exact.equals(value);
        }
        if (this.pattern != null) {
            return this.pattern.matcher(value).matches();
        }
        return true;
    }

    public String toString() {
        if (this.exact != null) {
            return "exact(" + this.exact + ")";
        }
        if (this.pattern != null) {
            return "regex(" + this.pattern.toString() + ")";
        }
        return "any()";
    }

    public String getSpec() {
        return this.spec;
    }
}

