/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class FieldAnnotation
extends PackageMemberAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "FIELD_DEFAULT";
    public static final String DID_YOU_MEAN_ROLE = "FIELD_DID_YOU_MEAN";
    public static final String VALUE_OF_ROLE = "FIELD_VALUE_OF";
    public static final String LOADED_FROM_ROLE = "FIELD_VALUE_OF";
    public static final String STORED_ROLE = "FIELD_STORED";
    public static final String INVOKED_ON_ROLE = "FIELD_INVOKED_ON";
    public static final String ARGUMENT_ROLE = "FIELD_ARGUMENT";
    private String fieldName;
    private String fieldSig;
    private String fieldSourceSig;
    private boolean isStatic;
    private static final String ELEMENT_NAME = "Field";

    public FieldAnnotation(@DottedClassName String className, String fieldName, String fieldSig, boolean isStatic) {
        super(className, DEFAULT_ROLE);
        if (fieldSig.indexOf(".") >= 0) {
            assert (false) : "signatures should not be dotted: " + fieldSig;
            fieldSig = fieldSig.replace('.', '/');
        }
        this.fieldName = fieldName;
        this.fieldSig = fieldSig;
        this.isStatic = isStatic;
    }

    public FieldAnnotation(@DottedClassName String className, String fieldName, String fieldSig, String fieldSourceSig, boolean isStatic) {
        this(className, fieldName, fieldSig, isStatic);
        this.fieldSourceSig = fieldSourceSig;
    }

    public FieldAnnotation(@DottedClassName String className, String fieldName, String fieldSig, int accessFlags) {
        this(className, fieldName, fieldSig, (accessFlags & 8) != 0);
    }

    public static FieldAnnotation fromVisitedField(PreorderVisitor visitor) {
        return new FieldAnnotation(visitor.getDottedClassName(), visitor.getFieldName(), visitor.getFieldSig(), visitor.getFieldIsStatic());
    }

    public static FieldAnnotation fromReferencedField(DismantleBytecode visitor) {
        String className = visitor.getDottedClassConstantOperand();
        return new FieldAnnotation(className, visitor.getNameConstantOperand(), visitor.getSigConstantOperand(), visitor.getRefFieldIsStatic());
    }

    public static FieldAnnotation fromBCELField(@DottedClassName String className, Field field) {
        return new FieldAnnotation(className, field.getName(), field.getSignature(), field.isStatic());
    }

    public static FieldAnnotation fromBCELField(JavaClass jClass, Field field) {
        return new FieldAnnotation(jClass.getClassName(), field.getName(), field.getSignature(), field.isStatic());
    }

    public static FieldAnnotation fromFieldDescriptor(FieldDescriptor fieldDescriptor) {
        return new FieldAnnotation(fieldDescriptor.getClassDescriptor().getDottedClassName(), fieldDescriptor.getName(), fieldDescriptor.getSignature(), fieldDescriptor.isStatic());
    }

    public static FieldAnnotation fromXField(XField fieldDescriptor) {
        return new FieldAnnotation(fieldDescriptor.getClassName(), fieldDescriptor.getName(), fieldDescriptor.getSignature(), fieldDescriptor.getSourceSignature(), fieldDescriptor.isStatic());
    }

    public XField toXField() {
        return XFactory.createXField(this.className, this.fieldName, this.fieldSig, this.isStatic);
    }

    public FieldDescriptor toFieldDescriptor() {
        return DescriptorFactory.instance().getFieldDescriptor(this);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldSignature() {
        return this.fieldSig;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public static FieldAnnotation isRead(Instruction ins, ConstantPoolGen cpg) {
        if (ins instanceof GETFIELD || ins instanceof GETSTATIC) {
            FieldInstruction fins = (FieldInstruction)ins;
            String className = fins.getClassName(cpg);
            return new FieldAnnotation(className, fins.getName(cpg), fins.getSignature(cpg), fins instanceof GETSTATIC);
        }
        return null;
    }

    public static FieldAnnotation isWrite(Instruction ins, ConstantPoolGen cpg) {
        if (ins instanceof PUTFIELD || ins instanceof PUTSTATIC) {
            FieldInstruction fins = (FieldInstruction)ins;
            String className = fins.getClassName(cpg);
            return new FieldAnnotation(className, fins.getName(cpg), fins.getSignature(cpg), fins instanceof PUTSTATIC);
        }
        return null;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitFieldAnnotation(this);
    }

    protected String formatPackageMember(String key, ClassAnnotation primaryClass) {
        if (key.equals("") || key.equals("hash")) {
            return this.className + "." + this.fieldName;
        }
        if (key.equals("givenClass")) {
            String primaryClassName = primaryClass.getClassName();
            if (this.className.equals(primaryClassName)) {
                return this.getNameInClass(primaryClass);
            }
            return FieldAnnotation.shorten(primaryClass.getPackageName(), this.className) + "." + this.fieldName;
        }
        if (key.equals("name")) {
            return this.fieldName;
        }
        if (key.equals("fullField")) {
            SignatureConverter converter = new SignatureConverter(this.fieldSig);
            StringBuilder result = new StringBuilder();
            if (this.isStatic) {
                result.append("static ");
            }
            result.append(converter.parseNext());
            result.append(' ');
            result.append(this.className);
            result.append('.');
            result.append(this.fieldName);
            return result.toString();
        }
        throw new IllegalArgumentException("unknown key " + key);
    }

    private String getNameInClass(ClassAnnotation primaryClass) {
        if (primaryClass == null) {
            return this.className + "." + this.fieldName;
        }
        String givenPackageName = primaryClass.getPackageName();
        String thisPackageName = this.getPackageName();
        if (thisPackageName.equals(givenPackageName)) {
            if (thisPackageName.length() == 0) {
                return this.fieldName;
            }
            return this.className.substring(thisPackageName.length() + 1) + "." + this.fieldName;
        }
        return this.className + "." + this.fieldName;
    }

    public int hashCode() {
        return this.className.hashCode() + this.fieldName.hashCode() + this.fieldSig.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldAnnotation)) {
            return false;
        }
        FieldAnnotation other = (FieldAnnotation)o;
        return this.className.equals(other.className) && this.fieldName.equals(other.fieldName) && this.fieldSig.equals(other.fieldSig) && this.isStatic == other.isStatic;
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof FieldAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        FieldAnnotation other = (FieldAnnotation)o;
        int cmp = this.className.compareTo(other.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.fieldName.compareTo(other.fieldName);
        if (cmp != 0) {
            return cmp;
        }
        return this.fieldSig.compareTo(other.fieldSig);
    }

    public SourceLineAnnotation getSourceLines() {
        if (this.sourceLines == null) {
            SourceInfoMap.SourceLineRange fieldLine;
            AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
            this.sourceLines = currentAnalysisContext == null ? new SourceLineAnnotation(this.className, this.sourceFileName, -1, -1, -1, -1) : ((fieldLine = currentAnalysisContext.getSourceInfoMap().getFieldLine(this.className, this.fieldName)) == null ? new SourceLineAnnotation(this.className, this.sourceFileName, -1, -1, -1, -1) : new SourceLineAnnotation(this.className, this.sourceFileName, fieldLine.getStart(), fieldLine.getEnd(), -1, -1));
        }
        return this.sourceLines;
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        String role;
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", this.getClassName()).addAttribute("name", this.getFieldName()).addAttribute("signature", this.getFieldSignature());
        if (this.fieldSourceSig != null) {
            attributeList.addAttribute("sourceSignature", this.fieldSourceSig);
        }
        attributeList.addAttribute("isStatic", String.valueOf(this.isStatic()));
        if (isPrimary) {
            attributeList.addAttribute("primary", "true");
        }
        if (!(role = this.getDescription()).equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        xmlOutput.openTag(ELEMENT_NAME, attributeList);
        this.getSourceLines().writeXML(xmlOutput, addMessages, false);
        if (addMessages) {
            xmlOutput.openTag("Message");
            xmlOutput.writeText(this.toString());
            xmlOutput.closeTag("Message");
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }
}

