/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageStats
implements XMLWriteable {
    public static final String ELEMENT_NAME = "PackageStats";
    public static final int ALL_ERRORS = 0;
    private final String packageName;
    private int[] nBugs = new int[]{0, 0, 0, 0, 0};
    private int size;
    private int numClasses;
    private Map<String, ClassStats> packageMembers = new HashMap<String, ClassStats>(5);

    public String toString() {
        return String.format("%s, %d classes, %d ncss", this.packageName, this.numClasses, this.size);
    }

    public PackageStats(String packageName) {
        this.packageName = packageName;
    }

    public PackageStats(String packageName, int numClasses, int size) {
        this(packageName);
        this.numClasses = numClasses;
        this.size = size;
    }

    public Collection<ClassStats> getClassStats() {
        return this.packageMembers.values();
    }

    public int getTotalBugs() {
        return this.nBugs[0];
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getBugsAtPriority(int p) {
        return this.nBugs[p];
    }

    private ClassStats getClassStats(String name, String sourceFile) {
        ClassStats result = this.packageMembers.get(name);
        if (result == null) {
            result = new ClassStats(name, sourceFile);
            this.packageMembers.put(name, result);
            this.numClasses = this.packageMembers.size();
        }
        return result;
    }

    @CheckForNull
    public ClassStats getClassStatsOrNull(String name) {
        ClassStats result = this.packageMembers.get(name);
        return result;
    }

    public void addError(BugInstance bug) {
        SourceLineAnnotation source = bug.getPrimarySourceLineAnnotation();
        if (bug.getPriority() >= this.nBugs.length) {
            return;
        }
        int n = bug.getPriority();
        this.nBugs[n] = this.nBugs[n] + 1;
        this.nBugs[0] = this.nBugs[0] + 1;
        this.getClassStats(source.getClassName(), source.getSourceFile()).addError(bug);
    }

    public void addClass(String name, String sourceFile, boolean isInterface, int size) {
        this.addClass(name, sourceFile, isInterface, size, true);
    }

    public void addClass(String name, String sourceFile, boolean isInterface, int size, boolean updatePackageStats) {
        ClassStats classStats = this.getClassStats(name, sourceFile);
        classStats.setInterface(isInterface);
        classStats.setSize(size);
        this.addClass(classStats, updatePackageStats);
    }

    public void addClass(ClassStats classStats) {
        this.addClass(classStats, true);
    }

    public void addClass(ClassStats classStats, boolean updatePackageStats) {
        if (this.packageMembers.isEmpty()) {
            this.size = 0;
            this.numClasses = 0;
        }
        this.packageMembers.put(classStats.getName(), classStats);
        if (updatePackageStats) {
            this.size += classStats.size();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        if (this.size == 0) {
            return;
        }
        xmlOutput.startTag(ELEMENT_NAME);
        xmlOutput.addAttribute("package", this.packageName);
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.nBugs[0]));
        int numClasses = this.packageMembers.size();
        if (numClasses == 0) {
            numClasses = this.numClasses;
        }
        xmlOutput.addAttribute("total_types", String.valueOf(numClasses));
        xmlOutput.addAttribute("total_size", String.valueOf(this.size));
        PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
        xmlOutput.stopTag(false);
        for (ClassStats classStats : this.getSortedClassStats()) {
            classStats.writeXML(xmlOutput);
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public Collection<ClassStats> getSortedClassStats() {
        TreeMap<String, ClassStats> sorted = new TreeMap<String, ClassStats>(this.packageMembers);
        return sorted.values();
    }

    public static void writeBugPriorities(XMLOutput xmlOutput, int[] bugs) throws IOException {
        int i = bugs.length;
        while (--i > 0) {
            if (bugs[i] <= 0) continue;
            xmlOutput.addAttribute("priority_" + i, String.valueOf(bugs[i]));
        }
    }

    public void recomputeFromClassStats() {
        for (int i = 0; i < this.nBugs.length; ++i) {
            this.nBugs[i] = 0;
        }
        this.size = 0;
        this.numClasses = this.packageMembers.size();
        for (ClassStats classStats : this.packageMembers.values()) {
            for (int i = 0; i < this.nBugs.length; ++i) {
                int n = i;
                this.nBugs[n] = this.nBugs[n] + classStats.getBugsAtPriority(i);
            }
            this.size += classStats.size;
        }
    }

    public void clearBugCounts() {
        for (int i = 0; i < this.nBugs.length; ++i) {
            this.nBugs[i] = 0;
        }
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.clearBugCounts();
        }
    }

    public void purgeClassesThatDontMatch(Pattern classPattern) {
        Iterator<Map.Entry<String, ClassStats>> i = this.packageMembers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ClassStats> e = i.next();
            if (classPattern.matcher(e.getKey()).find()) continue;
            i.remove();
        }
    }

    public static class ClassStats
    implements XMLWriteable,
    Cloneable {
        private final String name;
        private final String sourceFile;
        private boolean isInterface;
        private final int[] nBugs = new int[]{0, 0, 0, 0, 0};
        private int size;

        public ClassStats(String name, String sourceFile) {
            this.name = name;
            this.sourceFile = sourceFile;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void setInterface(boolean isInterface) {
            this.isInterface = isInterface;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void addError(BugInstance bug) {
            int n = bug.getPriority();
            this.nBugs[n] = this.nBugs[n] + 1;
            this.nBugs[0] = this.nBugs[0] + 1;
        }

        public int getTotalBugs() {
            return this.nBugs[0];
        }

        public int getBugsAtPriority(int p) {
            return this.nBugs[p];
        }

        public int size() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getSourceFile() {
            return this.sourceFile;
        }

        public void writeXML(XMLOutput xmlOutput) throws IOException {
            if (this.size == 0) {
                return;
            }
            xmlOutput.startTag("ClassStats");
            xmlOutput.addAttribute("class", this.name);
            if (this.sourceFile != null) {
                xmlOutput.addAttribute("sourceFile", this.sourceFile);
            }
            xmlOutput.addAttribute("interface", String.valueOf(this.isInterface));
            xmlOutput.addAttribute("size", String.valueOf(this.size));
            xmlOutput.addAttribute("bugs", String.valueOf(this.nBugs[0]));
            PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
            xmlOutput.stopTag(true);
        }

        public void clearBugCounts() {
            for (int i = 0; i < this.nBugs.length; ++i) {
                this.nBugs[i] = 0;
            }
        }
    }
}

