/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class JavaClassAndMethod {
    private final JavaClass javaClass;
    private final Method method;

    public JavaClassAndMethod(JavaClass javaClass, Method method) {
        this.javaClass = javaClass;
        this.method = method;
    }

    public JavaClassAndMethod(XMethod method) throws ClassNotFoundException {
        this.javaClass = Repository.lookupClass((String)method.getClassName());
        for (Method m : this.javaClass.getMethods()) {
            if (!m.getName().equals(method.getName()) || !m.getSignature().equals(method.getSignature()) || m.isStatic() != method.isStatic()) continue;
            this.method = m;
            return;
        }
        throw new IllegalArgumentException("Can't find " + method);
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public XMethod toXMethod() {
        return XFactory.createXMethod(this.javaClass, this.method);
    }

    public MethodDescriptor toMethodDescriptor() {
        return DescriptorFactory.instance().getMethodDescriptor(this.getSlashedClassName(), this.method.getName(), this.method.getSignature(), this.method.isStatic());
    }

    private String getSlashedClassName() {
        return this.javaClass.getConstantPool().getConstantString(this.javaClass.getClassNameIndex(), (byte)7);
    }

    public int hashCode() {
        return this.javaClass.hashCode() + this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JavaClassAndMethod other = (JavaClassAndMethod)obj;
        return this.javaClass.equals((Object)other.javaClass) && this.method.equals((Object)other.method);
    }

    public String toString() {
        return SignatureConverter.convertMethodSignature(this.javaClass, this.method);
    }
}

