/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParametersAreNonnullByDefault
public class ResourceValueAnalysis<Resource>
extends FrameDataflowAnalysis<ResourceValue, ResourceValueFrame>
implements EdgeTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean("dataflow.debug");
    private MethodGen methodGen;
    private CFG cfg;
    private ResourceTracker<Resource> resourceTracker;
    private Resource resource;
    private ResourceValueFrameModelingVisitor visitor;
    private boolean ignoreImplicitExceptions;

    public ResourceValueAnalysis(MethodGen methodGen, CFG cfg, DepthFirstSearch dfs, ResourceTracker<Resource> resourceTracker, Resource resource) {
        super(dfs);
        this.methodGen = methodGen;
        this.cfg = cfg;
        this.resourceTracker = resourceTracker;
        this.resource = resource;
        this.visitor = resourceTracker.createVisitor(resource, methodGen.getConstantPool());
        this.ignoreImplicitExceptions = resourceTracker.ignoreImplicitExceptions(resource);
    }

    @Override
    public ResourceValueFrame createFact() {
        ResourceValueFrame fact = new ResourceValueFrame(this.methodGen.getMaxLocals());
        fact.setTop();
        return fact;
    }

    @Override
    public void initEntryFact(ResourceValueFrame result) {
        result.setValid();
        result.clearStack();
        int numSlots = result.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            boolean slotContainsInstance = this.resourceTracker.isParamInstance(this.resource, i);
            result.setValue(i, slotContainsInstance ? ResourceValue.instance() : ResourceValue.notInstance());
        }
    }

    @Override
    public void meetInto(ResourceValueFrame fact, Edge edge, ResourceValueFrame result) throws DataflowAnalysisException {
        InstructionHandle lastInSourceHandle;
        int edgeType;
        BasicBlock source = (BasicBlock)edge.getSource();
        BasicBlock dest = (BasicBlock)edge.getTarget();
        ResourceValueFrame tmpFact = null;
        if (edge.isExceptionEdge()) {
            if (AnalysisContext.currentAnalysisContext().getBoolProperty(0) && this.ignoreImplicitExceptions && !edge.isFlagSet(2)) {
                return;
            }
            if (this.resourceTracker.ignoreExceptionEdge(edge, this.resource, this.methodGen.getConstantPool())) {
                return;
            }
            if (fact.getStatus() == 1) {
                tmpFact = this.modifyFrame(fact, null);
                tmpFact.setStatus(2);
            }
            if (fact.isValid()) {
                InstructionHandle exceptionThrower = source.getExceptionThrower();
                BasicBlock fallThroughSuccessor = this.cfg.getSuccessorWithEdgeType(source, 0);
                if (DEBUG && fallThroughSuccessor == null) {
                    System.out.println("Null fall through successor!");
                }
                if (fallThroughSuccessor != null && this.resourceTracker.isResourceClose(fallThroughSuccessor, exceptionThrower, this.methodGen.getConstantPool(), this.resource, fact)) {
                    tmpFact = this.modifyFrame(fact, tmpFact);
                    tmpFact.setStatus(3);
                    if (DEBUG) {
                        System.out.print("(failed attempt to close)");
                    }
                }
            }
            if (dest.isExceptionHandler() && fact.isValid()) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.clearStack();
                tmpFact.pushValue(ResourceValue.notInstance());
            }
        }
        if (((edgeType = edge.getType()) == 1 || edgeType == 0) && (lastInSourceHandle = source.getLastInstruction()) != null) {
            ResourceValueFrame frameAtIf;
            ResourceValue topValue;
            ResourceValueFrame startFrame;
            Instruction lastInSource = lastInSourceHandle.getInstruction();
            boolean isNullCheck = false;
            boolean isNonNullCheck = false;
            if (lastInSource instanceof IF_ACMPEQ || lastInSource instanceof IF_ACMPNE) {
                Location l = new Location(lastInSourceHandle, source);
                InstructionHandle ih = l.getHandle();
                InstructionHandle ihPrev = ih.getPrev();
                InstructionHandle ihPrevPrev = ihPrev == null ? null : ihPrev.getPrev();
                int prevPush = 0;
                if (ihPrev != null) {
                    prevPush = ihPrev.getInstruction().produceStack(this.methodGen.getConstantPool());
                }
                int prevPrevPush = 0;
                if (ihPrevPrev != null) {
                    prevPrevPush = ihPrevPrev.getInstruction().produceStack(this.methodGen.getConstantPool());
                }
                if (ihPrev != null && ihPrevPrev != null && prevPush == 1 && prevPrevPush == 1 && ihPrevPrev.getInstruction().getOpcode() == 1) {
                    isNullCheck = lastInSource instanceof IF_ACMPEQ;
                    isNonNullCheck = lastInSource instanceof IF_ACMPNE;
                }
            } else if (lastInSource instanceof IFNULL || lastInSource instanceof IFNONNULL) {
                isNullCheck = lastInSource instanceof IFNULL;
                isNonNullCheck = lastInSource instanceof IFNONNULL;
            }
            if ((isNullCheck || isNonNullCheck) && (startFrame = (ResourceValueFrame)this.getStartFact(source)).isValid() && (topValue = (ResourceValue)(frameAtIf = (ResourceValueFrame)this.getFactAtLocation(new Location(lastInSourceHandle, source))).getValue(frameAtIf.getNumSlots() - 1)).isInstance() && (isNullCheck && edgeType == 1 || isNonNullCheck && edgeType == 0)) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.setStatus(5);
            }
        }
        if (tmpFact != null) {
            fact = tmpFact;
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeInto(ResourceValueFrame frame, ResourceValueFrame result) throws DataflowAnalysisException {
        super.mergeInto(frame, result);
        result.setStatus(Math.min(result.getStatus(), frame.getStatus()));
    }

    @Override
    protected void mergeValues(ResourceValueFrame otherFrame, ResourceValueFrame resultFrame, int slot) throws DataflowAnalysisException {
        ResourceValue value = ResourceValue.merge((ResourceValue)resultFrame.getValue(slot), (ResourceValue)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, ResourceValueFrame fact) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(fact, new Location(handle, basicBlock));
        this.visitor.transferInstruction(handle, basicBlock);
    }
}

