/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedBytecodeCallback;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedCode;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnpackedCodeFactory
extends AnalysisFactory<UnpackedCode> {
    public UnpackedCodeFactory() {
        super("unpacked bytecode", UnpackedCode.class);
    }

    @Override
    public UnpackedCode analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        Method method = this.getMethod(analysisCache, descriptor);
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        UnpackedBytecodeCallback callback = new UnpackedBytecodeCallback(instructionList.length);
        BytecodeScanner scanner = new BytecodeScanner();
        scanner.scan(instructionList, callback);
        return callback.getUnpackedCode();
    }
}

