/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.NewFilterFromBug;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugTreeModel
implements TreeModel,
TableColumnModelListener,
TreeExpansionListener {
    private BugAspects root = new BugAspects();
    private SorterTableColumnModel st;
    private BugSet bugSet;
    private ArrayList<TreeModelListener> listeners = new ArrayList();
    private JTree tree;
    static ArrayList<BugLeafNode> selectedBugLeafNodes = new ArrayList();
    private static final boolean DEBUG = false;
    private volatile Thread rebuildingThread;
    private boolean sortOrderChanged;
    private boolean sortsAddedOrRemoved;
    private final MainFrame mainFrame;
    public static boolean TRACE = false;
    FilterListener bugTreeFilterListener = new MyFilterListener();

    public BugTreeModel(MainFrame mainFrame, JTree tree, SorterTableColumnModel st, BugSet data) {
        this.mainFrame = mainFrame;
        st.addColumnModelListener(this);
        this.tree = tree;
        this.st = st;
        this.bugSet = data;
        BugSet.setAsRootAndCache(this.bugSet);
        this.root.setCount(data.size());
        FilterActivity.addFilterListener(this.bugTreeFilterListener);
    }

    public BugTreeModel(BugTreeModel other) {
        this.mainFrame = other.mainFrame;
        this.root = new BugAspects(other.root);
        this.st = other.st;
        this.bugSet = new BugSet(other.bugSet);
        this.tree = other.tree;
    }

    public void getOffListenerList() {
        FilterActivity.removeFilterListener(this.bugTreeFilterListener);
        this.st.removeColumnModelListener(this);
        this.tree.removeTreeExpansionListener(this);
    }

    public void clearViewCache() {
        this.bugSet.clearCache();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object o, int index) {
        int childCount = this.getChildCount(o);
        if (index < 0 || index >= childCount) {
            return null;
        }
        Object result = this.getChild((BugAspects)o, index);
        assert (result != null);
        return result;
    }

    @Nonnull
    private Object getChild(BugAspects a, int index) {
        int treeLevels = this.st.getOrderBeforeDivider().size();
        int queryDepth = a.size();
        assert (queryDepth <= treeLevels);
        if (treeLevels == 0 && a.size() == 0) {
            BugLeafNode bugLeafNode = this.bugSet.get(index);
            assert (bugLeafNode != null);
            return bugLeafNode;
        }
        if (SystemProperties.ASSERTIONS_ENABLED) {
            for (int i = 0; i < queryDepth; ++i) {
                Sortables treeSortable = this.st.getOrderBeforeDivider().get(i);
                Sortables querySortable = a.get((int)i).key;
                assert (treeSortable.equals(querySortable)) : treeSortable + " vs " + querySortable;
            }
        }
        if (queryDepth < treeLevels) {
            BugAspects child = a.addToNew(this.enumsThatExist(a).get(index));
            child.setCount(this.bugSet.query(child).size());
            return child;
        }
        BugLeafNode bugLeafNode = this.bugSet.query(a).get(index);
        assert (bugLeafNode != null);
        return bugLeafNode;
    }

    @Override
    public int getChildCount(Object o) {
        if (!(o instanceof BugAspects)) {
            return 0;
        }
        BugAspects a = (BugAspects)o;
        if (this.st.getOrderBeforeDivider().size() == 0 && a.size() == 0) {
            return this.bugSet.size();
        }
        if (a.size() == 0 || a.last().key != this.st.getOrderBeforeDivider().get(this.st.getOrderBeforeDivider().size() - 1)) {
            return this.enumsThatExist(a).size();
        }
        return this.bugSet.query(a).size();
    }

    @Nonnull
    private List<BugAspects.SortableValue> enumsThatExist(BugAspects a) {
        Sortables lastKey;
        int index;
        List<Sortables> orderBeforeDivider = this.st.getOrderBeforeDivider();
        if (orderBeforeDivider.size() == 0) {
            List<BugAspects.SortableValue> result = Collections.emptyList();
            assert (false);
            return result;
        }
        Sortables key = a.size() == 0 ? orderBeforeDivider.get(0) : ((index = orderBeforeDivider.indexOf(lastKey = a.last().key)) + 1 < orderBeforeDivider.size() ? orderBeforeDivider.get(index + 1) : lastKey);
        String[] all = key.getAll(this.bugSet.query(a));
        ArrayList<BugAspects.SortableValue> result = new ArrayList<BugAspects.SortableValue>(all.length);
        for (String i : all) {
            result.add(new BugAspects.SortableValue(key, i));
        }
        return result;
    }

    @Override
    public boolean isLeaf(Object o) {
        return o instanceof BugLeafNode;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null || this.isLeaf(parent)) {
            return -1;
        }
        if (this.isLeaf(child)) {
            return this.bugSet.query((BugAspects)parent).indexOf((BugLeafNode)child);
        }
        List<BugAspects.SortableValue> stringPairs = this.enumsThatExist((BugAspects)parent);
        return stringPairs.indexOf(((BugAspects)child).last());
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.sortsAddedOrRemoved = true;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.sortsAddedOrRemoved = true;
    }

    @Override
    public void columnMoved(TableColumnModelEvent evt) {
        if (evt.getFromIndex() == evt.getToIndex()) {
            return;
        }
        this.sortOrderChanged = true;
    }

    public void needToRebuild() {
        this.sortOrderChanged = true;
    }

    void changeSet(BugSet set) {
        BugSet.setAsRootAndCache(set);
        this.bugSet = new BugSet(set);
        this.root.setCount(this.bugSet.size());
        this.rebuild();
    }

    public void rebuild() {
        if (TRACE) {
            System.out.println("rebuilding bug tree model");
        }
        NewFilterFromBug.closeAll();
        if (this.rebuildingThread == null) {
            this.setOldSelectedBugs();
        }
        Debug.println("Please Wait called right before starting rebuild thread");
        this.mainFrame.acquireDisplayWait();
        this.rebuildingThread = Util.runInDameonThread(new Runnable(){
            BugTreeModel newModel;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.newModel = new BugTreeModel(BugTreeModel.this);
                    this.newModel.listeners = BugTreeModel.this.listeners;
                    this.newModel.resetData();
                    this.newModel.bugSet.sortList();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    BugTreeModel.this.rebuildingThread = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (newModel != null) {
                                JTree newTree = new JTree(newModel);
                                newModel.tree = newTree;
                                ((BugTreeModel)BugTreeModel.this).mainFrame.mainFrameTree.newTree(newTree, newModel);
                                BugTreeModel.this.mainFrame.releaseDisplayWait();
                            }
                            BugTreeModel.this.getOffListenerList();
                        }
                    });
                    throw throwable;
                }
                BugTreeModel.this.rebuildingThread = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }, "Rebuilding thread");
    }

    public void crawl(ArrayList<BugAspects> path, int depth) {
        for (int i = 0; i < this.getChildCount(path.get(path.size() - 1)); ++i) {
            if (depth > 0) {
                ArrayList<BugAspects> newPath = new ArrayList<BugAspects>(path);
                newPath.add((BugAspects)this.getChild(path.get(path.size() - 1), i));
                this.crawl(newPath, depth - 1);
                continue;
            }
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, path.toArray()));
            }
        }
    }

    void openPreviouslySelected(List<BugLeafNode> selected) {
        Debug.printf("Starting Open Previously Selected for %d nodes\n", selected.size());
        for (BugLeafNode b : selected) {
            try {
                BugInstance bug = b.getBug();
                TreePath path = this.getPathToBug(bug);
                if (path == null) continue;
                Debug.printf("Opening %s\n", path);
                this.mainFrame.getTree().expandPath(path.getParentPath());
                this.mainFrame.getTree().addSelectionPath(path);
            }
            catch (RuntimeException e) {
                Debug.println("Failure opening a selected node, node will not be opened in new tree");
            }
        }
    }

    public void crawlToOpen(TreePath path, ArrayList<BugLeafNode> bugLeafNodes, ArrayList<TreePath> treePaths) {
        block0: for (int i = 0; i < this.getChildCount(path.getLastPathComponent()); ++i) {
            if (!this.isLeaf(this.getChild(path.getLastPathComponent(), i))) {
                for (BugLeafNode p : bugLeafNodes) {
                    if (!p.matches((BugAspects)this.getChild(path.getLastPathComponent(), i))) continue;
                    this.tree.expandPath(path);
                    this.crawlToOpen(path.pathByAddingChild(this.getChild(path.getLastPathComponent(), i)), bugLeafNodes, treePaths);
                    continue block0;
                }
                continue;
            }
            for (BugLeafNode b : bugLeafNodes) {
                if (!this.getChild(path.getLastPathComponent(), i).equals(b)) continue;
                this.tree.expandPath(path);
                treePaths.add(path.pathByAddingChild(this.getChild(path.getLastPathComponent(), i)));
            }
        }
    }

    public void resetData() {
        if (TRACE) {
            System.out.println("Reseting data in bug tree model");
        }
        this.bugSet = new BugSet(this.bugSet);
    }

    void treeNodeChanged(TreePath path) {
        Debug.println("Tree Node Changed: " + path);
        if (path.getParentPath() == null) {
            TreeModelEvent event = new TreeModelEvent((Object)this, path, null, null);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesChanged(event);
            }
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, path.getParentPath(), new int[]{this.getIndexOfChild(path.getParentPath().getLastPathComponent(), path.getLastPathComponent())}, new Object[]{path.getLastPathComponent()});
        for (TreeModelListener l : this.listeners) {
            l.treeNodesChanged(event);
        }
    }

    public TreePath getPathToBug(BugInstance b) {
        List<Sortables> order = this.st.getOrderBeforeDivider();
        BugAspects[] toBug = new BugAspects[order.size()];
        for (int i = 0; i < order.size(); ++i) {
            toBug[i] = new BugAspects();
        }
        for (int x = 0; x < order.size(); ++x) {
            for (int y = 0; y <= x; ++y) {
                Sortables s = order.get(y);
                toBug[x].add(new BugAspects.SortableValue(s, s.getFrom(b)));
            }
        }
        TreePath pathToBug = new TreePath(this.root);
        for (int x = 0; x < order.size(); ++x) {
            int index = this.getIndexOfChild(pathToBug.getLastPathComponent(), toBug[x]);
            if (index == -1) {
                if (MainFrame.GUI2_DEBUG) {
                    System.err.println("Node does not exist in the tree");
                }
                return null;
            }
            pathToBug = pathToBug.pathByAddingChild(this.getChild(pathToBug.getLastPathComponent(), index));
        }
        int index = this.getIndexOfChild(pathToBug.getLastPathComponent(), new BugLeafNode(b));
        if (index == -1) {
            return null;
        }
        pathToBug = pathToBug.pathByAddingChild(this.getChild(pathToBug.getLastPathComponent(), index));
        return pathToBug;
    }

    public TreePath getPathToNewlyUnsuppressedBug(BugInstance b) {
        this.resetData();
        return this.getPathToBug(b);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Debug.println("The BugTreeModel has been DELETED!  This means there are no more references to it, and its finally off all of the stupid listener lists");
    }

    @Override
    public void columnMarginChanged(ChangeEvent arg0) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private void setOldSelectedBugs() {
        selectedBugLeafNodes.clear();
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath path : this.tree.getSelectionPaths()) {
                if (!this.isLeaf(path.getLastPathComponent())) continue;
                selectedBugLeafNodes.add((BugLeafNode)path.getLastPathComponent());
            }
        }
    }

    ArrayList<BugLeafNode> getOldSelectedBugs() {
        return selectedBugLeafNodes;
    }

    void checkSorter() {
        if (this.sortOrderChanged || this.sortsAddedOrRemoved) {
            this.sortOrderChanged = false;
            this.sortsAddedOrRemoved = false;
            this.rebuild();
        }
    }

    public TreeModelEvent restructureBranch(ArrayList<String> stringsToBranch, boolean removing) throws BranchOperationException {
        if (removing) {
            return this.branchOperations(stringsToBranch, TreeModification.REMOVERESTRUCTURE);
        }
        return this.branchOperations(stringsToBranch, TreeModification.INSERTRESTRUCTURE);
    }

    public TreeModelEvent insertBranch(ArrayList<String> stringsToBranch) throws BranchOperationException {
        return this.branchOperations(stringsToBranch, TreeModification.INSERT);
    }

    public TreeModelEvent removeBranch(ArrayList<String> stringsToBranch) throws BranchOperationException {
        return this.branchOperations(stringsToBranch, TreeModification.REMOVE);
    }

    public void sortBranch(TreePath pathToBranch) {
        BugSet bs = this.bugSet.query((BugAspects)pathToBranch.getLastPathComponent());
        bs.sortList();
        Debug.println("Data in sorted branch: " + pathToBranch.getLastPathComponent());
        for (BugLeafNode b : bs) {
            Debug.println(b);
        }
        Object[] children = new Object[this.getChildCount(pathToBranch.getLastPathComponent())];
        int[] childIndices = new int[children.length];
        for (int x = 0; x < children.length; ++x) {
            children[x] = this.getChild(pathToBranch.getLastPathComponent(), x);
            childIndices[x] = x;
        }
        for (TreeModelListener l : this.listeners) {
            TreeModelEvent event = new TreeModelEvent((Object)this, pathToBranch, childIndices, children);
            l.treeNodesChanged(event);
        }
    }

    private TreeModelEvent branchOperations(ArrayList<String> stringsToBranch, TreeModification whatToDo) throws BranchOperationException {
        TreeModelEvent event = null;
        if (whatToDo == TreeModification.REMOVE) {
            Debug.println("Removing a branch......");
        } else if (whatToDo == TreeModification.INSERT) {
            Debug.println("Inserting a branch......");
        } else if (whatToDo == TreeModification.REMOVERESTRUCTURE) {
            Debug.println("Restructuring from branch to remove......");
        } else if (whatToDo == TreeModification.INSERTRESTRUCTURE) {
            Debug.println("Restructuring from branch to insert......");
        }
        Debug.println(stringsToBranch);
        if (whatToDo == TreeModification.INSERT || whatToDo == TreeModification.INSERTRESTRUCTURE) {
            this.resetData();
        }
        List<Sortables> order = this.st.getOrderBeforeDivider();
        BugAspects[] toBug = new BugAspects[stringsToBranch.size()];
        for (int x = 0; x < stringsToBranch.size(); ++x) {
            toBug[x] = new BugAspects();
            for (int y = 0; y <= x; ++y) {
                Sortables s = order.get(y);
                toBug[x].add(new BugAspects.SortableValue(s, stringsToBranch.get(y)));
            }
        }
        TreePath pathToBranch = new TreePath(this.root);
        for (int x = 0; x < stringsToBranch.size(); ++x) {
            BugAspects child = toBug[x];
            BugAspects parent = (BugAspects)pathToBranch.getLastPathComponent();
            if (this.getIndexOfChild(parent, child) == -1) {
                Debug.println(parent + " does not contain " + child);
                throw new BranchOperationException("Branch has been filtered out by another filter.");
            }
            pathToBranch = pathToBranch.pathByAddingChild(child);
        }
        if (pathToBranch.getParentPath() != null) {
            while (this.getChildCount(pathToBranch.getParentPath().getLastPathComponent()) == 1 && !pathToBranch.getParentPath().getLastPathComponent().equals(this.root)) {
                pathToBranch = pathToBranch.getParentPath();
            }
        }
        Debug.println(pathToBranch);
        if (whatToDo == TreeModification.INSERT) {
            event = new TreeModelEvent((Object)this, pathToBranch.getParentPath(), new int[]{this.getIndexOfChild(pathToBranch.getParentPath().getLastPathComponent(), pathToBranch.getLastPathComponent())}, new Object[]{pathToBranch.getLastPathComponent()});
        } else if (whatToDo == TreeModification.INSERTRESTRUCTURE) {
            event = new TreeModelEvent((Object)this, pathToBranch);
        }
        if (whatToDo == TreeModification.REMOVE) {
            event = new TreeModelEvent((Object)this, pathToBranch.getParentPath(), new int[]{this.getIndexOfChild(pathToBranch.getParentPath().getLastPathComponent(), pathToBranch.getLastPathComponent())}, new Object[]{pathToBranch.getLastPathComponent()});
        } else if (whatToDo == TreeModification.REMOVERESTRUCTURE) {
            event = new TreeModelEvent((Object)this, pathToBranch);
        }
        if (whatToDo == TreeModification.REMOVE || whatToDo == TreeModification.REMOVERESTRUCTURE) {
            this.resetData();
        }
        return event;
    }

    void sendEvent(TreeModelEvent event, TreeModification whatToDo) {
        Debug.println("Sending An Event!");
        if (event == null) {
            throw new IllegalStateException("Dont throw null events.");
        }
        this.resetData();
        for (TreeModelListener l : this.listeners) {
            if (whatToDo == TreeModification.REMOVE) {
                l.treeNodesRemoved(event);
                continue;
            }
            if (whatToDo == TreeModification.INSERT) {
                l.treeNodesInserted(event);
                l.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(event.getPath()).pathByAddingChild(event.getChildren()[0])));
                continue;
            }
            if (whatToDo != TreeModification.INSERTRESTRUCTURE && whatToDo != TreeModification.REMOVERESTRUCTURE) continue;
            l.treeStructureChanged(event);
        }
        this.root.setCount(this.bugSet.size());
        TreePath changedPath = new TreePath(this.root);
        this.treeNodeChanged(changedPath);
        changedPath = new TreePath(event.getPath());
        while (changedPath.getParentPath() != null) {
            this.treeNodeChanged(changedPath);
            changedPath = changedPath.getParentPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TreeModification {
        REMOVE,
        INSERT,
        REMOVERESTRUCTURE,
        INSERTRESTRUCTURE;

    }

    static class BranchOperationException
    extends Exception {
        public BranchOperationException(String s) {
            super(s);
        }
    }

    class MyFilterListener
    implements FilterListener {
        MyFilterListener() {
        }

        public void clearCache() {
            if (TRACE) {
                System.out.println("clearing cache in bug tree model");
            }
            BugTreeModel.this.resetData();
            BugSet.setAsRootAndCache(BugTreeModel.this.bugSet);
            BugTreeModel.this.root.setCount(BugTreeModel.this.bugSet.size());
            BugTreeModel.this.rebuild();
        }
    }
}

