/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.model;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class RegenerateClassFeatures {
    private BugCollection bugCollection;
    private String jarFile;

    public RegenerateClassFeatures(BugCollection bugCollection, String jarFile) {
        this.bugCollection = bugCollection;
        this.jarFile = jarFile;
    }

    public RegenerateClassFeatures execute() throws IOException {
        this.bugCollection.clearClassFeatures();
        ZipFile zipFile = new ZipFile(this.jarFile);
        ArrayList<JavaClass> classList = new ArrayList<JavaClass>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            ClassParser parser = new ClassParser(zipFile.getInputStream(entry), entry.getName());
            JavaClass javaClass = parser.parse();
            Repository.addClass((JavaClass)javaClass);
            classList.add(javaClass);
        }
        zipFile.close();
        for (JavaClass javaClass : classList) {
            ClassFeatureSet classFeatureSet = new ClassFeatureSet().initialize(javaClass);
            this.bugCollection.setClassFeatureSet(classFeatureSet);
        }
        return this;
    }

    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + RegenerateClassFeatures.class.getName() + " <bug collection> <jar file>");
            System.exit(1);
        }
        SortedBugCollection bugCollection = new SortedBugCollection();
        bugCollection.readXML(args[0]);
        new RegenerateClassFeatures(bugCollection, args[1]).execute();
        bugCollection.writeXML(System.out);
    }
}

