/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.analysis.FieldInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.classfile.engine.AbstractFieldAnnotationVisitor;
import edu.umd.cs.findbugs.classfile.engine.AbstractMethodVisitor;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.classfile.engine.ClassParserInterface;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.BitSet;
import java.util.HashSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassParserUsingASM
implements ClassParserInterface {
    private static final BitSet RETURN_OPCODE_SET = new BitSet();
    private final ClassReader classReader;
    @SlashedClassName
    private String slashedClassName;
    private final ClassDescriptor expectedClassDescriptor;
    private final ICodeBaseEntry codeBaseEntry;

    public ClassParserUsingASM(ClassReader classReader, @CheckForNull ClassDescriptor expectedClassDescriptor, ICodeBaseEntry codeBaseEntry) {
        this.classReader = classReader;
        this.expectedClassDescriptor = expectedClassDescriptor;
        this.codeBaseEntry = codeBaseEntry;
    }

    public void parse(final ClassNameAndSuperclassInfo.Builder cBuilder) throws InvalidClassFileFormatException {
        cBuilder.setCodeBaseEntry(this.codeBaseEntry);
        final TreeSet<ClassDescriptor> calledClassSet = new TreeSet<ClassDescriptor>();
        this.classReader.accept(new ClassVisitor(){
            boolean isInnerClass = false;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ClassParserUsingASM.this.slashedClassName = name;
                cBuilder.setClassfileVersion(version >>> 16, version & 0xFFFF);
                cBuilder.setAccessFlags(access);
                cBuilder.setClassDescriptor(DescriptorFactory.createClassDescriptor(name));
                cBuilder.setInterfaceDescriptorList(DescriptorFactory.createClassDescriptor(interfaces));
                if (superName != null) {
                    cBuilder.setSuperclassDescriptor(DescriptorFactory.createClassDescriptor(superName));
                }
                if (cBuilder instanceof ClassInfo.Builder) {
                    ((ClassInfo.Builder)cBuilder).setSourceSignature(signature);
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean isVisible) {
                if (cBuilder instanceof ClassInfo.Builder) {
                    AnnotationValue value = new AnnotationValue(desc);
                    ((ClassInfo.Builder)cBuilder).addAnnotation(desc, value);
                    return value.getAnnotationVisitor();
                }
                return null;
            }

            public void visitAttribute(Attribute arg0) {
            }

            public void visitEnd() {
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if (name.equals("this$0")) {
                    this.isInnerClass = true;
                }
                if (desc == null) {
                    throw new NullPointerException("Description cannot be null");
                }
                if (cBuilder instanceof ClassInfo.Builder) {
                    final ClassInfo.Builder cBuilder2 = (ClassInfo.Builder)cBuilder;
                    if ((access & 0x40) != 0 || desc.contains("util/concurrent")) {
                        cBuilder2.setUsesConcurrency();
                    }
                    final FieldInfo.Builder fBuilder = new FieldInfo.Builder(ClassParserUsingASM.this.slashedClassName, name, desc, access);
                    fBuilder.setSourceSignature(signature);
                    return new AbstractFieldAnnotationVisitor(){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationValue value = new AnnotationValue(desc);
                            fBuilder.addAnnotation(desc, value);
                            return value.getAnnotationVisitor();
                        }

                        public void visitEnd() {
                            cBuilder2.addFieldDescriptor(fBuilder.build());
                        }
                    };
                }
                return null;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (name.equals(ClassParserUsingASM.this.slashedClassName) && outerName != null && cBuilder instanceof ClassInfo.Builder) {
                    ClassDescriptor outerClassDescriptor = DescriptorFactory.createClassDescriptor(outerName);
                    ((ClassInfo.Builder)cBuilder).setImmediateEnclosingClass(outerClassDescriptor);
                    ((ClassInfo.Builder)cBuilder).setAccessFlags(access);
                }
            }

            public MethodVisitor visitMethod(final int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                if (cBuilder instanceof ClassInfo.Builder) {
                    final MethodInfo.Builder mBuilder = new MethodInfo.Builder(ClassParserUsingASM.this.slashedClassName, methodName, methodDesc, access);
                    mBuilder.setSourceSignature(signature);
                    mBuilder.setThrownExceptions(exceptions);
                    if ((access & 0x20) != 0) {
                        mBuilder.setUsesConcurrency();
                    }
                    return new AbstractMethodVisitor(){
                        boolean sawReturn;
                        boolean sawNormalThrow;
                        boolean sawUnsupportedThrow;
                        boolean sawSystemExit;
                        boolean sawBranch;
                        boolean sawBackBranch;
                        int methodCallCount;
                        int fieldInstructionCount;
                        boolean sawStubThrow;
                        boolean justSawInitializationOfUnsupportedOperationException;
                        boolean isBridge;
                        String bridgedMethodSignature;
                        IdentityMethodState identityState;
                        ParameterLoadState parameterLoadState;
                        int parameterForLoadState;
                        StubState stubState;
                        boolean isAccessMethod;
                        String accessOwner;
                        String accessName;
                        String accessDesc;
                        boolean accessForField;
                        boolean accessIsStatic;
                        HashSet<Label> labelsSeen;
                        {
                            this.sawReturn = (access & 0x100) != 0;
                            this.sawNormalThrow = false;
                            this.sawUnsupportedThrow = false;
                            this.sawSystemExit = false;
                            this.sawBranch = false;
                            this.sawBackBranch = false;
                            this.methodCallCount = 0;
                            this.fieldInstructionCount = 0;
                            this.sawStubThrow = false;
                            this.isBridge = (access & 0x1000) != 0 && (access & 0x40) != 0;
                            this.identityState = IdentityMethodState.INITIAL;
                            this.parameterLoadState = ParameterLoadState.OTHER;
                            this.stubState = StubState.INITIAL;
                            this.isAccessMethod = methodName.startsWith("access$");
                            this.labelsSeen = new HashSet();
                        }

                        boolean isStatic() {
                            return (access & 8) != 0;
                        }

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                            mBuilder.setVariableHasName(index);
                        }

                        public void visitLdcInsn(Object cst) {
                            this.stubState = cst.equals("Stub!") ? StubState.LOADED_STUB : StubState.INITIAL;
                            this.identityState = IdentityMethodState.NOT;
                        }

                        public void visitInsn(int opcode) {
                            switch (opcode) {
                                case 194: {
                                    mBuilder.setUsesConcurrency();
                                    break;
                                }
                                case 172: 
                                case 173: 
                                case 174: 
                                case 175: 
                                case 176: {
                                    if (this.identityState == IdentityMethodState.LOADED_PARAMETER) {
                                        mBuilder.setIsIdentity();
                                    }
                                    this.sawReturn = true;
                                    break;
                                }
                                case 177: {
                                    this.sawReturn = true;
                                    break;
                                }
                                case 191: {
                                    if (this.stubState == StubState.INITIALIZE_RUNTIME) {
                                        this.sawStubThrow = true;
                                        break;
                                    }
                                    if (this.justSawInitializationOfUnsupportedOperationException) {
                                        this.sawUnsupportedThrow = true;
                                        break;
                                    }
                                    this.sawNormalThrow = true;
                                }
                            }
                            this.resetState();
                        }

                        public void resetState() {
                            this.stubState = StubState.INITIAL;
                        }

                        public void visitSomeInsn() {
                            this.identityState = IdentityMethodState.NOT;
                            this.parameterLoadState = ParameterLoadState.OTHER;
                            this.resetState();
                        }

                        public void visitVarInsn(int opcode, int var) {
                            boolean match = false;
                            if (this.parameterLoadState == ParameterLoadState.OTHER && !this.isStatic() && var == 0) {
                                this.parameterLoadState = ParameterLoadState.LOADED_THIS;
                                match = true;
                            } else if (this.parameterLoadState == ParameterLoadState.LOADED_THIS && var > 0) {
                                this.parameterLoadState = ParameterLoadState.LOADED_THIS_AND_PARAMETER;
                                this.parameterForLoadState = var;
                                match = true;
                            }
                            if (this.identityState == IdentityMethodState.INITIAL) {
                                match = true;
                                this.identityState = var > 0 || this.isStatic() ? IdentityMethodState.LOADED_PARAMETER : IdentityMethodState.NOT;
                            }
                            if (!match) {
                                this.visitSomeInsn();
                            }
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (opcode == 181 && this.parameterLoadState == ParameterLoadState.LOADED_THIS_AND_PARAMETER && owner.equals(ClassParserUsingASM.this.slashedClassName) && name.startsWith("this$")) {
                                mBuilder.setVariableIsSynthetic(this.parameterForLoadState);
                            }
                            ++this.fieldInstructionCount;
                            if (this.isAccessMethod && this.accessOwner == null) {
                                this.accessOwner = owner;
                                this.accessName = name;
                                this.accessDesc = desc;
                                this.accessIsStatic = opcode == 178 || opcode == 179;
                                this.accessForField = true;
                            }
                            this.visitSomeInsn();
                        }

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationValue value = new AnnotationValue(desc);
                            mBuilder.addAnnotation(desc, value);
                            return value.getAnnotationVisitor();
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            this.identityState = IdentityMethodState.NOT;
                            ++this.methodCallCount;
                            if (this.isAccessMethod && this.accessOwner == null) {
                                this.accessOwner = owner;
                                this.accessName = name;
                                this.accessDesc = desc;
                                this.accessIsStatic = opcode == 184;
                                this.accessForField = false;
                            }
                            this.stubState = this.stubState == StubState.LOADED_STUB && opcode == 183 && owner.equals("java/lang/RuntimeException") && name.equals("<init>") ? StubState.INITIALIZE_RUNTIME : StubState.INITIAL;
                            if (owner.startsWith("java/util/concurrent")) {
                                mBuilder.setUsesConcurrency();
                            }
                            if (opcode == 185) {
                                return;
                            }
                            if (owner.charAt(0) == '[' && owner.charAt(owner.length() - 1) != ';') {
                                return;
                            }
                            if (opcode == 184 && owner.equals("java/lang/System") && name.equals("exit") && !this.sawReturn) {
                                this.sawSystemExit = true;
                            }
                            boolean bl = this.justSawInitializationOfUnsupportedOperationException = opcode == 183 && owner.equals("java/lang/UnsupportedOperationException") && name.equals("<init>");
                            if (this.isBridge && this.bridgedMethodSignature == null) {
                                switch (opcode) {
                                    case 182: 
                                    case 183: 
                                    case 184: 
                                    case 185: {
                                        if (desc == null || !name.equals(methodName)) break;
                                        this.bridgedMethodSignature = desc;
                                    }
                                }
                            }
                            if (desc == null || desc.indexOf(91) == -1 && desc.indexOf(76) == -1) {
                                return;
                            }
                            if (ClassParserUsingASM.this.slashedClassName.equals(owner)) {
                                return;
                            }
                            ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(owner);
                            calledClassSet.add(classDescriptor);
                        }

                        public void visitJumpInsn(int opcode, Label label) {
                            this.sawBranch = true;
                            if (this.labelsSeen.contains(label)) {
                                this.sawBackBranch = true;
                            }
                            this.identityState = IdentityMethodState.NOT;
                            super.visitJumpInsn(opcode, label);
                        }

                        public void visitLabel(Label label) {
                            this.labelsSeen.add(label);
                            super.visitLabel(label);
                        }

                        public void visitEnd() {
                            boolean sawThrow;
                            this.labelsSeen.clear();
                            if (this.isAccessMethod && this.accessOwner != null) {
                                if (!this.accessForField && this.methodCallCount == 1) {
                                    mBuilder.setAccessMethodForMethod(this.accessOwner, this.accessName, this.accessDesc, this.accessIsStatic);
                                } else if (this.accessForField && this.fieldInstructionCount == 1) {
                                    boolean isSetter = methodDesc.endsWith(")V");
                                    int numArg = new SignatureParser(methodDesc).getNumParameters();
                                    int expected = 0;
                                    if (!this.accessIsStatic) {
                                        ++expected;
                                    }
                                    if (isSetter) {
                                        ++expected;
                                    }
                                    boolean OK = isSetter ? methodDesc.substring(1).startsWith(ClassName.toSignature(this.accessOwner) + this.accessDesc) : methodDesc.substring(1).startsWith(ClassName.toSignature(this.accessOwner));
                                    if (numArg == expected && OK) {
                                        mBuilder.setAccessMethodForField(this.accessOwner, this.accessName, this.accessDesc, this.accessIsStatic);
                                    }
                                }
                            }
                            if (this.sawBackBranch) {
                                mBuilder.setHasBackBranch();
                            }
                            if ((sawThrow = this.sawNormalThrow | this.sawUnsupportedThrow | this.sawStubThrow) && !this.sawReturn || this.sawSystemExit && !this.sawBranch) {
                                mBuilder.setIsUnconditionalThrower();
                                if (!this.sawReturn && !this.sawNormalThrow) {
                                    if (this.sawUnsupportedThrow) {
                                        mBuilder.setUnsupported();
                                    }
                                    if (this.sawStubThrow) {
                                        mBuilder.addAccessFlags(4096);
                                        mBuilder.setIsStub();
                                    }
                                }
                            }
                            mBuilder.setNumberMethodCalls(this.methodCallCount);
                            MethodInfo methodInfo = mBuilder.build();
                            ClassInfo.Builder classBuilder = (ClassInfo.Builder)cBuilder;
                            if (this.isBridge && this.bridgedMethodSignature != null && !this.bridgedMethodSignature.equals(methodDesc)) {
                                classBuilder.addBridgeMethodDescriptor(methodInfo, this.bridgedMethodSignature);
                            } else {
                                classBuilder.addMethodDescriptor(methodInfo);
                            }
                            if (methodInfo.usesConcurrency()) {
                                classBuilder.setUsesConcurrency();
                            }
                            if (methodInfo.isStub()) {
                                classBuilder.setHasStubs();
                            }
                        }

                        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                            AnnotationValue value = new AnnotationValue(desc);
                            mBuilder.addParameterAnnotation(parameter, desc, value);
                            return value.getAnnotationVisitor();
                        }
                    };
                }
                return null;
            }

            public void visitOuterClass(String owner, String name, String desc) {
            }

            public void visitSource(String arg0, String arg1) {
                if (cBuilder instanceof ClassInfo.Builder) {
                    ((ClassInfo.Builder)cBuilder).setSource(arg0);
                }
            }
        }, 4);
        HashSet<ClassDescriptor> referencedClassSet = new HashSet<ClassDescriptor>();
        int constantPoolCount = this.classReader.readUnsignedShort(8);
        int offset = 10;
        char[] buf = new char[1024];
        for (int count = 1; count < constantPoolCount; ++count) {
            int size;
            int tag = this.classReader.readByte(offset);
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++count;
                    break;
                }
                case 1: {
                    size = 3 + this.classReader.readUnsignedShort(offset + 1);
                    break;
                }
                case 7: {
                    String className = this.classReader.readUTF8(offset + 1, buf);
                    if (className.indexOf(91) >= 0) {
                        ClassParser.extractReferencedClassesFromSignature(referencedClassSet, className);
                    } else if (ClassName.isValidClassName(className)) {
                        ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(className);
                        referencedClassSet.add(classDescriptor);
                    }
                    size = 3;
                    break;
                }
                case 8: {
                    size = 3;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tag of " + tag + " at offset " + offset + " while parsing " + this.slashedClassName + " from " + this.codeBaseEntry);
                }
            }
            offset += size;
        }
        cBuilder.setCalledClassDescriptors(calledClassSet);
        cBuilder.setReferencedClassDescriptors(referencedClassSet);
    }

    public void parse(ClassInfo.Builder builder) throws InvalidClassFileFormatException {
        this.parse((ClassNameAndSuperclassInfo.Builder)builder);
    }

    static {
        RETURN_OPCODE_SET.set(176);
        RETURN_OPCODE_SET.set(172);
        RETURN_OPCODE_SET.set(173);
        RETURN_OPCODE_SET.set(175);
        RETURN_OPCODE_SET.set(174);
        RETURN_OPCODE_SET.set(177);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParameterLoadState {
        OTHER,
        LOADED_THIS,
        LOADED_THIS_AND_PARAMETER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IdentityMethodState {
        INITIAL,
        LOADED_PARAMETER,
        NOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StubState {
        INITIAL,
        LOADED_STUB,
        INITIALIZE_RUNTIME;

    }
}

