/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SortableStringComparator;
import edu.umd.cs.findbugs.util.ClassName;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Sortables implements Comparator<String>
{
    FIRST_SEEN(L10N.getLocalString("sort.first_seen", "First Seen")){

        public String getFrom(BugInstance bug) {
            long firstSeen = this.getFirstSeen(bug);
            return Long.toString(firstSeen);
        }

        private long getFirstSeen(BugInstance bug) {
            BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
            long firstSeen = bugCollection.getCloud().getFirstSeen(bug);
            return firstSeen;
        }

        public String formatValue(String value) {
            long when = Long.parseLong(value);
            return DateFormat.getDateTimeInstance(3, 3).format(when);
        }

        public int compare(String one, String two) {
            return Long.valueOf(one).compareTo(Long.valueOf(two));
        }

        public boolean isAvailable(MainFrame mainframe) {
            BugCollection bugCollection = mainframe.getBugCollection();
            return bugCollection != null;
        }
    }
    ,
    FIRSTVERSION(L10N.getLocalString("sort.first_version", "First Version")){

        public String getFrom(BugInstance bug) {
            return Long.toString(bug.getFirstVersion());
        }

        public String formatValue(String value) {
            int seqNum = Integer.parseInt(value);
            BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
            if (bugCollection == null) {
                return "--";
            }
            AppVersion appVersion = bugCollection.getAppVersionFromSequenceNumber(seqNum);
            if (appVersion != null) {
                String timestamp = new Timestamp(appVersion.getTimestamp()).toString();
                return appVersion.getReleaseName() + " (" + timestamp.substring(0, timestamp.indexOf(32)) + ")";
            }
            return "#" + seqNum;
        }

        public int compare(String one, String two) {
            return Integer.valueOf(one).compareTo(Integer.valueOf(two));
        }

        public boolean isAvailable(MainFrame mainframe) {
            BugCollection bugCollection = mainframe.getBugCollection();
            if (bugCollection == null) {
                return true;
            }
            long sequenceNumber = bugCollection.getCurrentAppVersion().getSequenceNumber();
            return sequenceNumber > 0L;
        }
    }
    ,
    LASTVERSION(L10N.getLocalString("sort.last_version", "Last Version")){

        public String getFrom(BugInstance bug) {
            return Long.toString(bug.getLastVersion());
        }

        public String formatValue(String value) {
            if (value.equals("-1")) {
                return "";
            }
            int seqNum = Integer.parseInt(value);
            BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
            if (bugCollection == null) {
                return "--";
            }
            AppVersion appVersion = bugCollection.getAppVersionFromSequenceNumber(seqNum);
            if (appVersion != null) {
                String timestamp = new Timestamp(appVersion.getTimestamp()).toString();
                return appVersion.getReleaseName() + " (" + timestamp.substring(0, timestamp.indexOf(32)) + ")";
            }
            return "#" + seqNum;
        }

        public int compare(String one, String two) {
            int second;
            if (one.equals(two)) {
                return 0;
            }
            int first = Integer.valueOf(one);
            if (first == (second = Integer.valueOf(two).intValue())) {
                return 0;
            }
            if (first < 0) {
                return 1;
            }
            if (second < 0) {
                return -1;
            }
            if (first < second) {
                return -1;
            }
            return 1;
        }

        public boolean isAvailable(MainFrame mainframe) {
            BugCollection bugCollection = mainframe.getBugCollection();
            if (bugCollection == null) {
                return true;
            }
            return bugCollection.getCurrentAppVersion().getSequenceNumber() > 0L;
        }
    }
    ,
    PRIORITY(L10N.getLocalString("sort.priority", "Confidence")){

        public String getFrom(BugInstance bug) {
            return String.valueOf(bug.getPriority());
        }

        public String formatValue(String value) {
            if (value.equals(String.valueOf(1))) {
                return L10N.getLocalString("sort.priority_high", "High");
            }
            if (value.equals(String.valueOf(2))) {
                return L10N.getLocalString("sort.priority_normal", "Normal");
            }
            if (value.equals(String.valueOf(3))) {
                return L10N.getLocalString("sort.priority_low", "Low");
            }
            if (value.equals(String.valueOf(4))) {
                return L10N.getLocalString("sort.priority_experimental", "Experimental");
            }
            return L10N.getLocalString("sort.priority_ignore", "Ignore");
        }

        public int compare(String one, String two) {
            return Integer.valueOf(one).compareTo(Integer.valueOf(two));
        }
    }
    ,
    CLASS(L10N.getLocalString("sort.class", "Class")){

        public String getFrom(BugInstance bug) {
            return bug.getPrimarySourceLineAnnotation().getClassName();
        }

        public int compare(String one, String two) {
            try {
                if (one.contains("$") && two.contains("$") && one.substring(0, one.lastIndexOf("$")).equals(two.substring(0, two.lastIndexOf("$")))) {
                    return Integer.valueOf(one.substring(one.lastIndexOf("$"))).compareTo(Integer.valueOf(two.substring(two.lastIndexOf("$"))));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return one.compareTo(two);
        }
    }
    ,
    PACKAGE(L10N.getLocalString("sort.package", "Package")){

        public String getFrom(BugInstance bug) {
            return bug.getPrimarySourceLineAnnotation().getPackageName();
        }

        public String formatValue(String value) {
            if (value.equals("")) {
                return "(Default)";
            }
            return value;
        }
    }
    ,
    PACKAGE_PREFIX(L10N.getLocalString("sort.package_prefix", "Package prefix")){

        public String getFrom(BugInstance bug) {
            int count = GUISaveState.getInstance().getPackagePrefixSegments();
            if (count < 1) {
                count = 1;
            }
            String packageName = bug.getPrimarySourceLineAnnotation().getPackageName();
            return ClassName.extractPackagePrefix(packageName, count);
        }

        public String formatValue(String value) {
            return value + "...";
        }
    }
    ,
    CATEGORY(L10N.getLocalString("sort.category", "Category")){

        public String getFrom(BugInstance bug) {
            BugPattern bugPattern = bug.getBugPattern();
            return bugPattern.getCategory();
        }

        public String formatValue(String value) {
            return I18N.instance().getBugCategoryDescription(value);
        }

        public int compare(String one, String two) {
            String catOne = one;
            String catTwo = two;
            int compare = catOne.compareTo(catTwo);
            if (compare == 0) {
                return 0;
            }
            if (catOne.equals("CORRECTNESS")) {
                return -1;
            }
            if (catTwo.equals("CORRECTNESS")) {
                return 1;
            }
            return compare;
        }
    }
    ,
    DESIGNATION(L10N.getLocalString("sort.designation", "Designation")){

        public String getFrom(BugInstance bug) {
            return bug.getUserDesignationKey();
        }

        public String formatValue(String value) {
            return I18N.instance().getUserDesignation(value);
        }

        public String[] getAllSorted() {
            List<String> sortedDesignations = I18N.instance().getUserDesignationKeys(true);
            return sortedDesignations.toArray(new String[sortedDesignations.size()]);
        }
    }
    ,
    BUGCODE(L10N.getLocalString("sort.bug_kind", "Bug Kind")){

        public String getFrom(BugInstance bug) {
            BugPattern bugPattern = bug.getBugPattern();
            return bugPattern.getAbbrev();
        }

        public String formatValue(String value) {
            return I18N.instance().getBugTypeDescription(value);
        }

        public int compare(String one, String two) {
            return this.formatValue(one).compareTo(this.formatValue(two));
        }
    }
    ,
    TYPE(L10N.getLocalString("sort.bug_pattern", "Bug Pattern")){

        public String getFrom(BugInstance bug) {
            return bug.getBugPattern().getType();
        }

        public String formatValue(String value) {
            return I18N.instance().getShortMessageWithoutCode(value);
        }
    }
    ,
    CONSENSUS(L10N.getLocalString("sort.consensus", "Consensus")){

        public String getFrom(BugInstance bug) {
            BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
            return bugCollection.getCloud().getConsensusDesignation(bug).name();
        }

        public String formatValue(String value) {
            return I18N.instance().getUserDesignation(value);
        }

        public boolean isAvailable(MainFrame mf) {
            BugCollection bugCollection = mf.getBugCollection();
            if (bugCollection == null || bugCollection.getCloud() == null) {
                return false;
            }
            return bugCollection.getCloud().getMode() == Cloud.Mode.COMMUNAL;
        }
    }
    ,
    BUG_RANK(L10N.getLocalString("sort.bug_bugrank", "Bug Rank")){
        String[] values = new String[40];
        {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = String.format("%2d", i);
            }
        }

        public String getFrom(BugInstance bug) {
            int rank = BugRanker.findRank(bug);
            return this.values[rank];
        }

        public String formatValue(String value) {
            return value;
        }
    }
    ,
    BUG_STATUS(L10N.getLocalString("sort.bug_bugstatus", "Status")){

        public String getFrom(BugInstance bug) {
            String bugStatus;
            BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
            Cloud cloud = bugCollection.getCloud();
            assert (cloud != null);
            Cloud.BugFilingStatus status = cloud.getBugLinkStatus(bug);
            if (status == Cloud.BugFilingStatus.VIEW_BUG && (bugStatus = cloud.getBugStatus(bug)) != null) {
                return bugStatus;
            }
            return CONSENSUS.getFrom(bug);
        }

        public String formatValue(String value) {
            return value;
        }

        public boolean isAvailable(MainFrame mf) {
            BugCollection bugCollection = mf.getBugCollection();
            if (bugCollection == null || bugCollection.getCloud() == null) {
                return false;
            }
            boolean a = bugCollection.getCloud().supportsBugLinks() && bugCollection.getCloud().getMode() == Cloud.Mode.COMMUNAL;
            return a;
        }
    }
    ,
    PROJECT(L10N.getLocalString("sort.bug_project", "Project")){

        public String getFrom(BugInstance bug) {
            ProjectPackagePrefixes p = MainFrame.getInstance().getProjectPackagePrefixes();
            TreeSet<String> projects = p.getProjects(bug.getPrimaryClass().getClassName());
            if (projects.size() == 0) {
                return "unclassified";
            }
            String result = ((Object)projects).toString();
            return result.substring(1, result.length() - 1);
        }

        public boolean isAvailable(MainFrame mf) {
            return mf.getProjectPackagePrefixes().size() > 0;
        }
    }
    ,
    DIVIDER(" "){

        public String getFrom(BugInstance bug) {
            throw new UnsupportedOperationException();
        }

        public String[] getAll() {
            throw new UnsupportedOperationException();
        }

        public String formatValue(String value) {
            throw new UnsupportedOperationException();
        }

        public int compare(String one, String two) {
            throw new UnsupportedOperationException();
        }
    };

    String prettyName;
    private SortableStringComparator comparator = new SortableStringComparator(this);
    final Comparator<BugLeafNode> bugLeafNodeComparator;

    private Sortables(String prettyName) {
        this.prettyName = prettyName;
        this.bugLeafNodeComparator = new Comparator<BugLeafNode>(){

            @Override
            public int compare(BugLeafNode one, BugLeafNode two) {
                return Sortables.this.compare(Sortables.this.getFrom(one.getBug()), Sortables.this.getFrom(two.getBug()));
            }
        };
    }

    public String toString() {
        return this.prettyName;
    }

    public abstract String getFrom(BugInstance var1);

    public String[] getAll() {
        return this.getAll(BugSet.getMainBugSet());
    }

    public String[] getAll(BugSet set) {
        return set.getAll(this);
    }

    public String formatValue(String value) {
        return value;
    }

    @Override
    public int compare(String one, String two) {
        return one.compareTo(two);
    }

    public String[] getAllSorted() {
        return this.getAllSorted(BugSet.getMainBugSet());
    }

    public String[] getAllSorted(BugSet set) {
        String[] values = this.getAll(set);
        Arrays.sort(values, this);
        return values;
    }

    public SortableStringComparator getComparator() {
        return this.comparator;
    }

    public Comparator<BugLeafNode> getBugLeafNodeComparator() {
        return this.bugLeafNodeComparator;
    }

    public boolean isAvailable(MainFrame frame) {
        return true;
    }

    public static Sortables getSortableByPrettyName(String name) {
        for (Sortables s : Sortables.values()) {
            if (!s.prettyName.equals(name)) continue;
            return s;
        }
        return null;
    }
}

