/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildNonNullAnnotationDatabase
extends AnnotationVisitor {
    private static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug.annotation");
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, AnnotationDatabase.Target> defaultKind = new HashMap<String, AnnotationDatabase.Target>();
    private NullnessAnnotationDatabase database;

    public BuildNonNullAnnotationDatabase(@CheckForNull NullnessAnnotationDatabase database) {
        this.database = database;
    }

    static String lastPortion(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    private void handleClassElementValue(ClassElementValue value, AnnotationDatabase.Target annotationTarget) {
        NullnessAnnotation n = NullnessAnnotation.Parser.parse(value.getClassString());
        if (n != null) {
            this.database.addDefaultAnnotation(annotationTarget, this.getDottedClassName(), n);
        }
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        NullnessAnnotation n = NullnessAnnotation.Parser.parse(annotationClass);
        annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass);
        if (n == null) {
            if (annotationClass.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
                AnnotationDatabase.Target annotationTarget = defaultKind.get(annotationClass = annotationClass.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
                if (annotationTarget != AnnotationDatabase.Target.METHOD) {
                    return;
                }
                ElementValue v = map.get("value");
                if (v instanceof ClassElementValue) {
                    this.handleClassElementValue((ClassElementValue)v, annotationTarget);
                } else if (v instanceof ArrayElementValue) {
                    for (ElementValue v2 : ((ArrayElementValue)v).getElementValuesArray()) {
                        if (!(v2 instanceof ClassElementValue)) continue;
                        this.handleClassElementValue((ClassElementValue)v2, annotationTarget);
                    }
                }
                return;
            }
        } else if (this.visitingMethod()) {
            this.database.addDirectAnnotation(XFactory.createXMethod(this), n);
        } else if (this.visitingField()) {
            this.database.addDirectAnnotation(XFactory.createXField(this), n);
        }
    }

    @Override
    public void visitSyntheticParameterAnnotation(int p, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod(this);
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        this.database.addDirectAnnotation(xparameter, NullnessAnnotation.UNKNOWN_NULLNESS);
    }

    @Override
    public void visitParameterAnnotation(int p, String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        NullnessAnnotation n = NullnessAnnotation.Parser.parse(annotationClass);
        annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass);
        if (n == null) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod(this);
        if (DEBUG) {
            System.out.println("Parameter " + p + " @" + annotationClass.substring(annotationClass.lastIndexOf(47) + 1) + " in " + xmethod.toString());
        }
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        this.database.addDirectAnnotation(xparameter, n);
    }

    static {
        defaultKind.put("", AnnotationDatabase.Target.ANY);
        defaultKind.put("ForParameters", AnnotationDatabase.Target.PARAMETER);
        defaultKind.put("ForMethods", AnnotationDatabase.Target.METHOD);
        defaultKind.put("ForFields", AnnotationDatabase.Target.FIELD);
    }
}

