/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeFactory {
    private static ThreadLocal<Map<String, ObjectType>> instance = new ThreadLocal<Map<String, ObjectType>>(){

        @Override
        protected Map<String, ObjectType> initialValue() {
            return new HashMap<String, ObjectType>();
        }
    };

    public static void clearInstance() {
        instance.remove();
    }

    public static ObjectType getInstance(Class<?> c) {
        return ObjectTypeFactory.getInstance(c.getName());
    }

    public static ObjectType getInstance(@DottedClassName String s) {
        Map<String, ObjectType> map;
        ObjectType result;
        if (FindBugs.DEBUG && s.startsWith("[")) {
            throw new IllegalArgumentException("Cannot create an ObjectType to represent an array type: " + s);
        }
        if (s.endsWith(";")) {
            throw new IllegalArgumentException(s);
        }
        if (s.indexOf("/") >= 0) {
            s = s.replace('/', '.');
        }
        if ((result = (map = instance.get()).get(s)) != null) {
            return result;
        }
        result = ObjectType.getInstance((String)s);
        map.put(s, result);
        return result;
    }
}

