/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractMethod;
import edu.umd.cs.findbugs.ba.ComparableMethod;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnresolvedXMethod
extends AbstractMethod {
    Map<Integer, Map<ClassDescriptor, AnnotationValue>> methodParameterAnnotations = Collections.emptyMap();
    Map<ClassDescriptor, AnnotationValue> methodAnnotations = Collections.emptyMap();

    protected UnresolvedXMethod(MethodDescriptor m) {
        super(m.getClassDescriptor().getDottedClassName(), m.getName(), m.getSignature(), m.isStatic() ? 8 : 0);
        if (XFactory.DEBUG_UNRESOLVED) {
            System.out.println("Unresolved xmethod: " + this);
        }
    }

    @Override
    public boolean isReturnTypeReferenceType() {
        SignatureParser parser = new SignatureParser(this.getSignature());
        String returnTypeSig = parser.getReturnTypeSignature();
        return SignatureParser.isReferenceType(returnTypeSig);
    }

    @Override
    public int compareTo(ComparableMethod o) {
        if (o instanceof XMethod) {
            return XFactory.compare(this, (XMethod)o);
        }
        throw new ClassCastException("Don't know how to compare " + this.getClass().getName() + " to " + o.getClass().getName());
    }

    @Override
    public ElementType getElementType() {
        if (this.getName().equals("<init>")) {
            return ElementType.CONSTRUCTOR;
        }
        return ElementType.METHOD;
    }

    @Override
    @CheckForNull
    public AnnotatedObject getContainingScope() {
        try {
            return Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getClassDescriptor());
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @Override
    public String[] getThrownExceptions() {
        return new String[0];
    }

    @Override
    public boolean isUnconditionalThrower() {
        return false;
    }

    @Override
    public boolean isUnsupported() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public boolean usesConcurrency() {
        return false;
    }

    @Override
    @CheckForNull
    public String getSourceSignature() {
        return null;
    }

    @Override
    public boolean isStub() {
        return false;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public void addParameterAnnotation(int param, AnnotationValue annotationValue) {
        HashMap<Integer, Map<ClassDescriptor, AnnotationValue>> updatedAnnotations = new HashMap<Integer, Map<ClassDescriptor, AnnotationValue>>(this.methodParameterAnnotations);
        Map<ClassDescriptor, AnnotationValue> paramMap = updatedAnnotations.get(param);
        if (paramMap == null) {
            paramMap = new HashMap<ClassDescriptor, AnnotationValue>();
            updatedAnnotations.put(param, paramMap);
        }
        paramMap.put(annotationValue.getAnnotationClass(), annotationValue);
        this.methodParameterAnnotations = updatedAnnotations;
    }

    @Override
    public Collection<ClassDescriptor> getParameterAnnotationDescriptors(int param) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    @Nullable
    public AnnotationValue getParameterAnnotation(int param, ClassDescriptor desc) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return null;
        }
        return map.get(desc);
    }

    @Override
    public Collection<AnnotationValue> getParameterAnnotations(int param) {
        Map<ClassDescriptor, AnnotationValue> map = this.methodParameterAnnotations.get(param);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.values();
    }

    @Override
    public void addAnnotation(AnnotationValue annotationValue) {
        HashMap<ClassDescriptor, AnnotationValue> updatedAnnotations = new HashMap<ClassDescriptor, AnnotationValue>(this.methodAnnotations);
        updatedAnnotations.put(annotationValue.getAnnotationClass(), annotationValue);
        this.methodAnnotations = updatedAnnotations;
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return this.methodAnnotations.keySet();
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return this.methodAnnotations.get(desc);
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return this.methodAnnotations.values();
    }

    @Override
    public XMethod bridgeFrom() {
        return null;
    }

    @Override
    public XMethod bridgeTo() {
        return null;
    }

    @Override
    public MethodDescriptor getAccessMethodForMethod() {
        return null;
    }

    @Override
    public FieldDescriptor getAccessMethodForField() {
        return null;
    }

    @Override
    public boolean isVariableSynthetic(int param) {
        return false;
    }
}

