/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.updates.PluginUpdateListener;
import edu.umd.cs.findbugs.updates.UpdateCheckCallback;
import edu.umd.cs.findbugs.updates.UpdateChecker;
import edu.umd.cs.findbugs.util.ClassPathUtil;
import edu.umd.cs.findbugs.util.FutureValue;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactoryCollection
implements UpdateCheckCallback {
    private static final Logger LOGGER = Logger.getLogger(DetectorFactoryCollection.class.getName());
    private static final boolean DEBUG_JAWS = SystemProperties.getBoolean("findbugs.jaws.debug");
    private static DetectorFactoryCollection theInstance;
    private static final Object lock;
    private final Map<String, Plugin> pluginByIdMap = new LinkedHashMap<String, Plugin>();
    private Plugin corePlugin;
    private final List<DetectorFactory> factoryList = new ArrayList<DetectorFactory>();
    private final Map<String, DetectorFactory> factoriesByName = new HashMap<String, DetectorFactory>();
    private final Map<String, DetectorFactory> factoriesByDetectorClassName = new HashMap<String, DetectorFactory>();
    private final Map<String, CloudPlugin> registeredClouds = new LinkedHashMap<String, CloudPlugin>();
    protected final Map<String, BugCategory> categoryDescriptionMap = new HashMap<String, BugCategory>();
    protected final Map<String, BugPattern> bugPatternMap = new HashMap<String, BugPattern>();
    protected final Map<String, BugCode> bugCodeMap = new HashMap<String, BugCode>();
    private final UpdateChecker updateChecker;
    private final CopyOnWriteArrayList<PluginUpdateListener> pluginUpdateListeners = new CopyOnWriteArrayList();
    private volatile List<UpdateChecker.PluginUpdate> updates;
    private boolean updatesForced;
    private final Collection<Plugin> pluginsToUpdate;
    final Map<String, String> globalOptions = new HashMap<String, String>();
    final Map<String, Plugin> globalOptionsSetter = new HashMap<String, Plugin>();

    protected DetectorFactoryCollection() {
        this(true, false, Plugin.getAllPlugins(), new ArrayList<Plugin>());
    }

    protected DetectorFactoryCollection(Plugin onlyPlugin) {
        this(false, true, Collections.singleton(onlyPlugin), new ArrayList<Plugin>());
    }

    protected DetectorFactoryCollection(Collection<Plugin> enabled) {
        this(true, true, enabled, enabled);
    }

    private DetectorFactoryCollection(boolean loadCore, boolean forceLoad, @Nonnull Collection<Plugin> pluginsToLoad, @Nonnull Collection<Plugin> enabledPlugins) {
        if (loadCore) {
            this.loadCorePlugin();
        }
        for (Plugin plugin : pluginsToLoad) {
            if (!forceLoad && (!plugin.isGloballyEnabled() || plugin.isCorePlugin())) continue;
            this.loadPlugin(plugin);
            if (enabledPlugins.contains(plugin)) continue;
            enabledPlugins.add(plugin);
        }
        this.setGlobalOptions();
        this.updateChecker = new UpdateChecker(this);
        this.pluginsToUpdate = this.combine(enabledPlugins);
    }

    public void checkForUpdates(boolean force) {
        this.updateChecker.checkForUpdates(this.pluginsToUpdate, force);
    }

    private Collection<Plugin> combine(Collection<Plugin> enabled) {
        ArrayList<Plugin> result = new ArrayList<Plugin>(enabled);
        if (this.corePlugin != null && !result.contains(this.corePlugin)) {
            result.add(this.corePlugin);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInstance(@CheckForNull DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection instance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            return theInstance;
        }
    }

    private void setGlobalOptions() {
        this.globalOptions.clear();
        this.globalOptionsSetter.clear();
        for (Plugin p : this.plugins()) {
            if (!p.isGloballyEnabled()) continue;
            for (Map.Entry<String, String> e : p.getMyGlobalOptions().entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                String oldValue = this.globalOptions.get(key);
                if (oldValue != null) {
                    if (oldValue.equals(value)) continue;
                    Plugin oldP = this.globalOptionsSetter.get(key);
                    throw new RuntimeException("Incompatible global options for " + key + "; conflict between " + oldP.getPluginId() + " and " + p.getPluginId());
                }
                this.globalOptions.put(key, value);
                this.globalOptionsSetter.put(key, p);
            }
        }
    }

    @Override
    @CheckForNull
    public String getGlobalOption(String key) {
        return this.globalOptions.get(key);
    }

    @Override
    @CheckForNull
    public Plugin getGlobalOptionSetter(String key) {
        return this.globalOptionsSetter.get(key);
    }

    public Iterator<Plugin> pluginIterator() {
        return this.pluginByIdMap.values().iterator();
    }

    public Collection<Plugin> plugins() {
        return this.pluginByIdMap.values();
    }

    @Nonnull
    public Plugin getCorePlugin() {
        if (this.corePlugin == null) {
            throw new IllegalStateException("No core plugin");
        }
        return this.corePlugin;
    }

    public Plugin getPluginById(String pluginId) {
        return this.pluginByIdMap.get(pluginId);
    }

    public Iterator<DetectorFactory> factoryIterator() {
        return this.factoryList.iterator();
    }

    public Iterable<DetectorFactory> getFactories() {
        return this.factoryList;
    }

    public DetectorFactory getFactory(String name) {
        return this.factoriesByName.get(name);
    }

    public DetectorFactory getFactoryByClassName(String className) {
        return this.factoriesByDetectorClassName.get(className);
    }

    void registerDetector(DetectorFactory factory) {
        if (FindBugs.DEBUG) {
            System.out.println("Registering detector: " + factory.getFullName());
        }
        String detectorName = factory.getShortName();
        if (!this.factoryList.contains(factory)) {
            this.factoryList.add(factory);
        } else {
            LOGGER.log(Level.WARNING, "Trying to add already registered factory: " + factory + ", " + factory.getPlugin());
        }
        this.factoriesByName.put(detectorName, factory);
        this.factoriesByDetectorClassName.put(factory.getFullName(), factory);
    }

    void unRegisterDetector(DetectorFactory factory) {
        if (FindBugs.DEBUG) {
            System.out.println("Unregistering detector: " + factory.getFullName());
        }
        String detectorName = factory.getShortName();
        this.factoryList.remove(factory);
        this.factoriesByName.remove(detectorName);
        this.factoriesByDetectorClassName.remove(factory.getFullName());
    }

    private static String inferFindBugsHome() {
        Pattern[] findbugsJarNames;
        for (Pattern jarNamePattern : findbugsJarNames = new Pattern[]{Pattern.compile("findbugs\\.jar$")}) {
            File findbugsJar;
            File libDir;
            String findbugsJarCodeBase = ClassPathUtil.findCodeBaseInClassPath(jarNamePattern, SystemProperties.getProperty("java.class.path"));
            if (findbugsJarCodeBase == null || !(libDir = (findbugsJar = new File(findbugsJarCodeBase)).getParentFile()).getName().equals("lib")) continue;
            String fbHome = libDir.getParent();
            FindBugs.setHome(fbHome);
            return fbHome;
        }
        String classFilePath = FindBugs.class.getName().replaceAll("\\.", "/") + ".class";
        URL resource = FindBugs.class.getClassLoader().getResource(classFilePath);
        if (resource != null && resource.getProtocol().equals("file")) {
            try {
                String home;
                String classfile = URLDecoder.decode(resource.getPath(), Charset.defaultCharset().name());
                Matcher m = Pattern.compile("(.*)/.*?/edu/umd.*").matcher(classfile);
                if (m.matches() && new File((home = m.group(1)) + "/etc/findbugs.xml").exists()) {
                    FindBugs.setHome(home);
                    return home;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getFindBugsHome() {
        String homeDir = FindBugs.getHome();
        if (homeDir == null) {
            homeDir = DetectorFactoryCollection.inferFindBugsHome();
        }
        return homeDir;
    }

    @CheckForNull
    public static URL getCoreResource(String name) {
        return PluginLoader.getCoreResource(name);
    }

    private void loadCorePlugin() {
        Plugin plugin = PluginLoader.getCorePluginLoader().getPlugin();
        this.loadPlugin(plugin);
        this.corePlugin = plugin;
    }

    public static void jawsDebugMessage(String message) {
        if (DEBUG_JAWS) {
            JOptionPane.showMessageDialog(null, message);
        } else if (FindBugs.DEBUG) {
            System.err.println(message);
        }
    }

    void loadPlugin(Plugin plugin) {
        if (FindBugs.DEBUG) {
            System.out.println("Loading " + plugin.getPluginId());
        }
        this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        this.setGlobalOptions();
        for (DetectorFactory factory : plugin.getDetectorFactories()) {
            this.registerDetector(factory);
        }
        for (BugCategory bugCategory : plugin.getBugCategories()) {
            this.registerBugCategory(bugCategory);
        }
        for (BugPattern bugPattern : plugin.getBugPatterns()) {
            this.registerBugPattern(bugPattern);
        }
        for (BugCode bugCode : plugin.getBugCodes()) {
            this.registerBugCode(bugCode);
        }
        for (CloudPlugin cloud : plugin.getCloudPlugins()) {
            this.registerCloud(cloud);
        }
    }

    void unLoadPlugin(Plugin plugin) {
        this.pluginByIdMap.remove(plugin.getPluginId());
        this.setGlobalOptions();
        for (DetectorFactory factory : plugin.getDetectorFactories()) {
            this.unRegisterDetector(factory);
        }
        for (BugCategory bugCategory : plugin.getBugCategories()) {
            this.unRegisterBugCategory(bugCategory);
        }
        for (BugPattern bugPattern : plugin.getBugPatterns()) {
            this.unRegisterBugPattern(bugPattern);
        }
        for (BugCode bugCode : plugin.getBugCodes()) {
            this.unRegisterBugCode(bugCode);
        }
        for (CloudPlugin cloud : plugin.getCloudPlugins()) {
            this.unRegisterCloud(cloud);
        }
    }

    @Override
    public void pluginUpdateCheckComplete(List<UpdateChecker.PluginUpdate> newUpdates, boolean force) {
        this.updates = newUpdates;
        this.updatesForced = force;
        for (PluginUpdateListener listener : this.pluginUpdateListeners) {
            try {
                listener.pluginUpdateCheckComplete(newUpdates, force);
            }
            catch (Throwable e) {
                LOGGER.log(Level.INFO, "Error during update check callback", e);
            }
        }
    }

    public void addPluginUpdateListener(PluginUpdateListener listener) {
        this.pluginUpdateListeners.add(listener);
        if (this.updates != null) {
            listener.pluginUpdateCheckComplete(this.updates, this.updatesForced);
        } else if (!this.updateChecker.updateChecksGloballyDisabled()) {
            this.checkForUpdates(false);
        }
    }

    public FutureValue<Collection<UpdateChecker.PluginUpdate>> getUpdates() {
        final FutureValue<Collection<UpdateChecker.PluginUpdate>> results = new FutureValue<Collection<UpdateChecker.PluginUpdate>>();
        this.addPluginUpdateListener(new PluginUpdateListener(){

            @Override
            public void pluginUpdateCheckComplete(Collection<UpdateChecker.PluginUpdate> u, boolean force) {
                results.set(u);
            }
        });
        return results;
    }

    public Map<String, CloudPlugin> getRegisteredClouds() {
        return Collections.unmodifiableMap(this.registeredClouds);
    }

    void registerCloud(CloudPlugin cloudPlugin) {
        LOGGER.log(Level.FINE, "Registering " + cloudPlugin.getId());
        this.registeredClouds.put(cloudPlugin.getId(), cloudPlugin);
    }

    void unRegisterCloud(CloudPlugin cloudPlugin) {
        LOGGER.log(Level.FINE, "Unregistering " + cloudPlugin.getId());
        this.registeredClouds.remove(cloudPlugin.getId());
    }

    public boolean registerBugCategory(BugCategory bc) {
        String category = bc.getCategory();
        if (this.categoryDescriptionMap.get(category) != null) {
            return false;
        }
        this.categoryDescriptionMap.put(category, bc);
        return true;
    }

    protected boolean unRegisterBugCategory(BugCategory bc) {
        String category = bc.getCategory();
        this.categoryDescriptionMap.remove(category);
        return true;
    }

    public void registerBugPattern(BugPattern bugPattern) {
        this.bugPatternMap.put(bugPattern.getType(), bugPattern);
    }

    protected void unRegisterBugPattern(BugPattern bugPattern) {
        this.bugPatternMap.remove(bugPattern.getType());
    }

    public Iterator<BugPattern> bugPatternIterator() {
        return this.bugPatternMap.values().iterator();
    }

    public Collection<BugPattern> getBugPatterns() {
        return this.bugPatternMap.values();
    }

    @CheckForNull
    public BugPattern lookupBugPattern(String bugType) {
        return this.bugPatternMap.get(bugType);
    }

    public void registerBugCode(BugCode bugCode) {
        this.bugCodeMap.put(bugCode.getAbbrev(), bugCode);
    }

    protected void unRegisterBugCode(BugCode bugCode) {
        this.bugCodeMap.remove(bugCode.getAbbrev());
    }

    public Collection<BugCode> getBugCodes() {
        return this.bugCodeMap.values();
    }

    public BugCode getBugCode(String shortBugType) {
        BugCode bugCode = this.lookupBugCode(shortBugType);
        if (bugCode == null) {
            throw new IllegalArgumentException("Error: missing bug code for key" + shortBugType);
        }
        return bugCode;
    }

    public BugCode lookupBugCode(String shortBugType) {
        return this.bugCodeMap.get(shortBugType);
    }

    public BugCategory getBugCategory(String category) {
        return this.categoryDescriptionMap.get(category);
    }

    public Collection<String> getBugCategories() {
        ArrayList<String> result = new ArrayList<String>(this.categoryDescriptionMap.size());
        for (BugCategory c : this.categoryDescriptionMap.values()) {
            if (c.isHidden()) continue;
            result.add(c.getCategory());
        }
        return result;
    }

    public Collection<BugCategory> getBugCategoryObjects() {
        return this.categoryDescriptionMap.values();
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    static {
        lock = new Object();
    }
}

