/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreemptiveAuthHttpClient
extends DefaultHttpClient {
    private boolean preemptiveAuthentication = false;

    public PreemptiveAuthHttpClient(ClientConnectionManager ccm) {
        super(ccm);
    }

    protected void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Object result;
        if (this.preemptiveAuthentication) {
            BasicHttpContext context = this.generateContext(target);
            result = super.execute(target, request, responseHandler, (HttpContext)context);
        } else {
            result = super.execute(target, request, responseHandler);
        }
        return (T)result;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Object result;
        if (this.preemptiveAuthentication) {
            URI uri = request.getURI();
            String host = uri.getHost();
            int port = uri.getPort();
            HttpHost target = new HttpHost(host, port);
            result = super.execute(request, responseHandler, (HttpContext)this.generateContext(target));
        } else {
            result = super.execute(request, responseHandler);
        }
        return (T)result;
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        if (this.preemptiveAuthentication) {
            context = this.generateContext(target);
        }
        return (T)super.execute(target, request, responseHandler, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        if (this.preemptiveAuthentication) {
            URI uri = request.getURI();
            String host = uri.getHost();
            int port = uri.getPort();
            HttpHost target = new HttpHost(host, port);
            context = this.generateContext(target);
        }
        return (T)super.execute(request, responseHandler, context);
    }

    private BasicHttpContext generateContext(HttpHost target) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        return context;
    }
}

