/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class Invoke
extends PatternElement {
    public static final int INSTANCE = 1;
    public static final int STATIC = 2;
    public static final int CONSTRUCTOR = 4;
    public static final int ORDINARY_METHOD = 3;
    public static final int ANY = 7;
    private final StringMatcher classNameMatcher;
    private final StringMatcher methodNameMatcher;
    private final StringMatcher methodSigMatcher;
    private final int mode;

    public Invoke(String className, String methodName, String methodSig, int mode, @Nullable RepositoryLookupFailureCallback lookupFailureCallback) {
        this.classNameMatcher = this.createClassMatcher(className);
        this.methodNameMatcher = this.createMatcher(methodName);
        this.methodSigMatcher = this.createMatcher(methodSig);
        this.mode = mode;
    }

    private StringMatcher createClassMatcher(String s) {
        return s.startsWith("+") ? new SubclassMatcher(s.substring(1)) : this.createMatcher(s);
    }

    private StringMatcher createMatcher(String s) {
        return s.startsWith("/") ? new RegexpStringMatcher(s.substring(1)) : new ExactStringMatcher(s);
    }

    public MatchResult match(InstructionHandle handle, ConstantPoolGen cpg, ValueNumberFrame before, ValueNumberFrame after, BindingSet bindingSet) throws DataflowAnalysisException {
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof InvokeInstruction)) {
            return null;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        String methodName = inv.getMethodName(cpg);
        boolean isStatic = inv.getOpcode() == 184;
        boolean isCtor = methodName.equals("<init>");
        int actualMode = 0;
        if (isStatic) {
            actualMode |= 2;
        }
        if (isCtor) {
            actualMode |= 4;
        }
        if (!isStatic && !isCtor) {
            actualMode |= 1;
        }
        if ((actualMode & this.mode) == 0) {
            return null;
        }
        if (!(this.methodNameMatcher.match(methodName) && this.methodSigMatcher.match(inv.getSignature(cpg)) && this.classNameMatcher.match(inv.getClassName(cpg)))) {
            return null;
        }
        return new MatchResult(this, bindingSet);
    }

    public boolean acceptBranch(Edge edge, InstructionHandle source) {
        return true;
    }

    public int minOccur() {
        return 1;
    }

    public int maxOccur() {
        return 1;
    }

    private static class SubclassMatcher
    implements StringMatcher {
        private String className;

        public SubclassMatcher(String className) {
            this.className = className;
        }

        public boolean match(String s) {
            try {
                return Hierarchy.isSubtype(s, this.className);
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
                return false;
            }
        }
    }

    private static class RegexpStringMatcher
    implements StringMatcher {
        private Pattern pattern;

        public RegexpStringMatcher(String re) {
            this.pattern = Pattern.compile(re);
        }

        public boolean match(String s) {
            return this.pattern.matcher(s).matches();
        }
    }

    private static class ExactStringMatcher
    implements StringMatcher {
        private String value;

        public ExactStringMatcher(String value) {
            this.value = value;
        }

        public boolean match(String s) {
            return s.equals(this.value);
        }
    }

    private static interface StringMatcher {
        public boolean match(String var1);
    }
}

