/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSignatureParser {
    private final String signature;

    public GenericSignatureParser(String signature) {
        int s = signature.indexOf(40);
        String sig = signature;
        if (s > 0) {
            sig = sig.substring(s);
        } else if (s < 0 || sig.indexOf(58) >= 0 || sig.startsWith("(V)")) {
            throw new IllegalArgumentException("Bad method signature: " + signature);
        }
        this.signature = sig;
    }

    public Iterator<String> parameterSignatureIterator() {
        return new ParameterSignatureIterator();
    }

    public String getReturnTypeSignature() {
        int endOfParams = this.signature.lastIndexOf(41);
        if (endOfParams < 0) {
            throw new IllegalArgumentException("Bad method signature: " + this.signature);
        }
        return this.signature.substring(endOfParams + 1);
    }

    public int getNumParameters() {
        int count = 0;
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public static int getNumParametersForInvocation(InvokeInstruction inv, ConstantPoolGen cpg) {
        GenericSignatureParser sigParser = new GenericSignatureParser(inv.getSignature(cpg));
        return sigParser.getNumParameters();
    }

    @CheckForNull
    public static Iterator<String> getGenericSignatureIterator(Method target) {
        try {
            GenericSignatureParser parser = null;
            String genericSignature = null;
            for (Attribute a : target.getAttributes()) {
                if (!(a instanceof Signature)) continue;
                Signature sig = (Signature)a;
                if (genericSignature != null) {
                    if (genericSignature.equals(sig.getSignature())) continue;
                    return null;
                }
                genericSignature = sig.getSignature();
                if (!GenericSignatureParser.compareSignatures(target.getSignature(), genericSignature)) continue;
                parser = new GenericSignatureParser(genericSignature);
            }
            Iterator<String> iter = parser == null ? null : parser.parameterSignatureIterator();
            return iter;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static boolean compareSignatures(String plainSignature, String genericSignature) {
        GenericSignatureParser plainParser = new GenericSignatureParser(plainSignature);
        GenericSignatureParser genericParser = new GenericSignatureParser(genericSignature);
        return plainParser.getNumParameters() == genericParser.getNumParameters();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: " + GenericSignatureParser.class.getName() + " '<method signature>'");
            System.exit(1);
        }
        GenericSignatureParser parser = new GenericSignatureParser(args[0]);
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            String s = i.next();
            System.out.println(s);
            Type t = GenericUtilities.getType(s);
            System.out.println("-~- " + t);
            if (t instanceof ObjectType) {
                System.out.println("-~- " + ((ObjectType)t).toString());
            }
            if (t == null) continue;
            System.out.println("-~- " + t.getClass());
        }
        System.out.println(parser.getNumParameters() + " parameter(s)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterSignatureIterator
    implements Iterator<String> {
        private int index = 1;

        private ParameterSignatureIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < GenericSignatureParser.this.signature.length() && GenericSignatureParser.this.signature.charAt(this.index) != ')' && GenericSignatureParser.this.signature.charAt(this.index) != '^';
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String next() {
            boolean done;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder result = new StringBuilder();
            do {
                done = true;
                char ch = GenericSignatureParser.this.signature.charAt(this.index);
                switch (ch) {
                    case '*': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        break;
                    }
                    case 'L': 
                    case 'T': {
                        String tmp = "";
                        int startsemi = this.index;
                        int leftCount = 0;
                        int i = startsemi + 1;
                        block12: while (true) {
                            char c = GenericSignatureParser.this.signature.charAt(i);
                            switch (c) {
                                case ';': {
                                    if (leftCount != 0) break;
                                    break block12;
                                }
                                case '<': {
                                    ++leftCount;
                                    break;
                                }
                                case '>': {
                                    --leftCount;
                                }
                            }
                            ++i;
                        }
                        String foo = GenericSignatureParser.this.signature.substring(startsemi, i + 1);
                        result.append(foo);
                        this.index = i + 1;
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '[': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        done = false;
                        break;
                    }
                    case ')': 
                    case '^': {
                        throw new NoSuchElementException("Should have already thrown NoSuchElementException");
                    }
                    default: {
                        throw new IllegalStateException("Invalid method signature: '" + GenericSignatureParser.this.signature + "' : " + GenericSignatureParser.this.signature.substring(this.index) + " " + result);
                    }
                }
            } while (!done);
            return result.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

