/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.detect.IOStreamFactory;
import edu.umd.cs.findbugs.detect.InstanceFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.MethodReturnValueStreamFactory;
import edu.umd.cs.findbugs.detect.StaticFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEquivalenceClass;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamResourceTracker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindOpenStream
extends ResourceTrackingDetector<Stream, StreamResourceTracker>
implements StatelessDetector {
    static final boolean DEBUG = SystemProperties.getBoolean("fos.debug");
    static final boolean IGNORE_WRAPPED_UNINTERESTING_STREAMS = !SystemProperties.getBoolean("fos.allowWUS");
    static final ObjectType[] streamBaseList = new ObjectType[]{ObjectTypeFactory.getInstance("java.io.InputStream"), ObjectTypeFactory.getInstance("java.io.OutputStream"), ObjectTypeFactory.getInstance("java.util.zip.ZipFile"), ObjectTypeFactory.getInstance("java.io.Reader"), ObjectTypeFactory.getInstance("java.io.Writer"), ObjectTypeFactory.getInstance("java.sql.Connection"), ObjectTypeFactory.getInstance("java.sql.Statement"), ObjectTypeFactory.getInstance("java.sql.ResultSet")};
    static final StreamFactory[] streamFactoryList;
    private List<PotentialOpenStream> potentialOpenStreamList = new LinkedList<PotentialOpenStream>();
    private static final String[] PRESCREEN_CLASS_LIST;

    public FindOpenStream(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        boolean sawResourceClass = false;
        block0: for (int i = 0; i < jclass.getConstantPool().getLength(); ++i) {
            int classIndex;
            ConstantMethodref cmr;
            Constant constant = jclass.getConstantPool().getConstant(i);
            String className = null;
            if (constant instanceof ConstantMethodref) {
                cmr = (ConstantMethodref)constant;
                classIndex = cmr.getClassIndex();
                className = jclass.getConstantPool().getConstantString(classIndex, (byte)7);
            } else if (constant instanceof ConstantInterfaceMethodref) {
                cmr = (ConstantInterfaceMethodref)constant;
                classIndex = cmr.getClassIndex();
                className = jclass.getConstantPool().getConstantString(classIndex, (byte)7);
            }
            if (className == null) continue;
            if (DEBUG) {
                System.out.println("FindOpenStream: saw class " + className);
            }
            for (String aPRESCREEN_CLASS_LIST : PRESCREEN_CLASS_LIST) {
                if (className.indexOf(aPRESCREEN_CLASS_LIST) < 0) continue;
                sawResourceClass = true;
                continue block0;
            }
        }
        if (sawResourceClass) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public boolean prescreen(ClassContext classContext, Method method, boolean mightClose) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        return bytecodeSet.get(187) || bytecodeSet.get(185) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(182);
    }

    @Override
    public StreamResourceTracker getResourceTracker(ClassContext classContext, Method method) {
        return new StreamResourceTracker(streamFactoryList, this.bugReporter);
    }

    public static boolean isMainMethod(Method method) {
        return method.isStatic() && method.getName().equals("main") && method.getSignature().equals("([Ljava/lang/String;)V");
    }

    @Override
    public void analyzeMethod(ClassContext classContext, Method method, StreamResourceTracker resourceTracker, ResourceCollection<Stream> resourceCollection) throws CFGBuilderException, DataflowAnalysisException {
        this.potentialOpenStreamList.clear();
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        try {
            Type[] parameterTypeList = Type.getArgumentTypes((String)methodGen.getSignature());
            Location firstLocation = new Location(cfg.getEntry().getFirstInstruction(), cfg.getEntry());
            int local = methodGen.isStatic() ? 0 : 1;
            block5: for (Type type : parameterTypeList) {
                if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    for (ObjectType streamBase : streamBaseList) {
                        if (!Hierarchy.isSubtype((ReferenceType)objectType, (ReferenceType)streamBase)) continue;
                        Stream paramStream = new Stream(firstLocation, objectType.getClassName(), streamBase.getClassName());
                        paramStream.setIsOpenOnCreation(true);
                        paramStream.setOpenLocation(firstLocation);
                        paramStream.setInstanceParam(local);
                        resourceCollection.addPreexistingResource(paramStream);
                        break;
                    }
                }
                switch (type.getType()) {
                    case 7: 
                    case 11: {
                        local += 2;
                        continue block5;
                    }
                    default: {
                        ++local;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        resourceTracker.setResourceCollection(resourceCollection);
        super.analyzeMethod(classContext, method, resourceTracker, resourceCollection);
        resourceTracker.markTransitiveUninterestingStreamEscapes();
        Iterator<Stream> i = resourceCollection.resourceIterator();
        while (i.hasNext()) {
            Stream stream = i.next();
            StreamEquivalenceClass equivalenceClass = resourceTracker.getStreamEquivalenceClass(stream);
            if (!stream.isClosed()) continue;
            equivalenceClass.setClosed();
        }
        for (PotentialOpenStream pos : this.potentialOpenStreamList) {
            Location openLocation;
            Stream stream = pos.stream;
            if (stream.isClosed() || stream.isUninteresting() || (openLocation = stream.getOpenLocation()) == null || IGNORE_WRAPPED_UNINTERESTING_STREAMS && resourceTracker.isUninterestingStreamEscape(stream)) continue;
            String sourceFile = javaClass.getSourceFileName();
            String leakClass = stream.getStreamBase();
            if (FindOpenStream.isMainMethod(method) && (leakClass.contains("InputStream") || leakClass.contains("Reader"))) {
                return;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, pos.bugType, pos.priority).addClassAndMethod(methodGen, sourceFile).addTypeOfNamedClass(leakClass).describe("TYPE_CLOSEIT"), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, stream.getLocation().getHandle()));
        }
    }

    @Override
    public void inspectResult(ClassContext classContext, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>> dataflow, Stream stream) {
        ResourceValueFrame exitFrame;
        int exitStatus;
        if (DEBUG) {
            System.out.printf("Result for %s in %s%n", stream, methodGen);
            dataflow.dumpDataflow(dataflow.getAnalysis());
        }
        if ((exitStatus = (exitFrame = dataflow.getResultFact(cfg.getExit())).getStatus()) == 1 || exitStatus == 2) {
            String bugType = stream.getBugType();
            int priority = 2;
            if (exitStatus == 2) {
                bugType = bugType + "_EXCEPTION_PATH";
                priority = 3;
            }
            this.potentialOpenStreamList.add(new PotentialOpenStream(bugType, priority, stream));
        } else if (exitStatus == 3) {
            stream.setClosed();
        }
    }

    static {
        ArrayList<StreamFactory> streamFactoryCollection = new ArrayList<StreamFactory>();
        streamFactoryCollection.add(new IOStreamFactory("java.io.InputStream", new String[]{"java.io.ByteArrayInputStream", "java.io.StringBufferInputStream", "java.io.PipedInputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.OutputStream", new String[]{"java.io.ByteArrayOutputStream", "java.io.PipedOutputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Reader", new String[]{"java.io.StringReader", "java.io.CharArrayReader", "java.io.PipedReader"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Writer", new String[]{"java.io.StringWriter", "java.io.CharArrayWriter", "java.io.PipedWriter"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.util.zip.ZipFile", new String[0], "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.lang.Class", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getInputStream", "()Ljava/io/InputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getOutputStream", "()Ljava/io/OutputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.servlet.ServletRequest", "getInputStream", "()Ljavax/servlet/ServletInputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.servlet.ServletRequest", "getReader", "()Ljava/io/BufferedReader;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.servlet.ServletResponse", "getOutputStream", "()Ljavax/servlet/ServletOutputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.servlet.ServletResponse", "getWriter", "()Ljava/io/PrintWriter;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.InputStream", "java.lang.System", "in", "Ljava/io/InputStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "out", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "err", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.InputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Reader"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.OutputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Writer"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.sql.DataSource", "getConnection", "()Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.sql.DataSource", "getConnection", "(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "()Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(II)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(III)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryList = streamFactoryCollection.toArray(new StreamFactory[streamFactoryCollection.size()]);
        PRESCREEN_CLASS_LIST = new String[]{"Stream", "Reader", "Writer", "ZipFile", "JarFile", "DriverManager", "Connection", "Statement"};
    }

    private static class PotentialOpenStream {
        public final String bugType;
        public final int priority;
        public final Stream stream;

        public String toString() {
            return this.stream.toString();
        }

        public PotentialOpenStream(String bugType, int priority, Stream stream) {
            this.bugType = bugType;
            this.priority = priority;
            this.stream = stream;
        }
    }
}

