/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableStaticFields
extends BytecodeScanningDetector {
    LinkedList<XField> seen = new LinkedList();
    boolean publicClass;
    boolean zeroOnTOS;
    boolean emptyArrayOnTOS;
    boolean inStaticInitializer;
    String packageName;
    Set<XField> readAnywhere = new HashSet<XField>();
    Set<XField> unsafeValue = new HashSet<XField>();
    Set<XField> notFinal = new HashSet<XField>();
    Set<XField> outsidePackage = new HashSet<XField>();
    Set<XField> needsRefactoringToBeFinal = new HashSet<XField>();
    Set<XField> writtenInMethod = new HashSet<XField>();
    Set<XField> writtenTwiceInMethod = new HashSet<XField>();
    Map<XField, SourceLineAnnotation> firstFieldUse = new HashMap<XField, SourceLineAnnotation>();
    private final BugReporter bugReporter;
    private boolean isEclipseNLS;

    static String extractPackage(String c) {
        int i = c.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return c.substring(0, i);
    }

    static boolean mutableSignature(String sig) {
        return sig.equals("Ljava/util/Hashtable;") || sig.equals("Ljava/util/Date;") || sig.equals("Ljava/sql/Date;") || sig.equals("Ljava/sql/Timestamp;") || sig.charAt(0) == '[';
    }

    public MutableStaticFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        this.publicClass = (flags & 1) != 0 && !this.getDottedClassName().startsWith("sun.");
        this.packageName = MutableStaticFields.extractPackage(this.getClassName());
        this.isEclipseNLS = "org.eclipse.osgi.util.NLS".equals(obj.getSuperclassName());
    }

    public void visit(Method obj) {
        this.zeroOnTOS = false;
        this.inStaticInitializer = this.getMethodName().equals("<clinit>");
    }

    public void visit(Code obj) {
        this.writtenInMethod.clear();
        this.writtenTwiceInMethod.clear();
        super.visit(obj);
        if (this.inStaticInitializer) {
            this.needsRefactoringToBeFinal.addAll(this.writtenTwiceInMethod);
        }
        this.writtenInMethod.clear();
        this.writtenTwiceInMethod.clear();
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 178: 
            case 179: {
                boolean safeValue;
                XField xField = this.getXFieldOperand();
                if (xField == null || !this.interesting(xField)) break;
                boolean samePackage = this.packageName.equals(MutableStaticFields.extractPackage(this.getClassConstantOperand()));
                boolean initOnly = seen == 178 || this.getClassName().equals(this.getClassConstantOperand()) && this.inStaticInitializer;
                boolean bl = safeValue = seen == 178 || this.emptyArrayOnTOS || AnalysisContext.currentXFactory().isEmptyArrayField(xField) || !MutableStaticFields.mutableSignature(this.getSigConstantOperand());
                if (seen == 178) {
                    this.readAnywhere.add(xField);
                }
                if (seen == 179 && !this.writtenInMethod.add(xField)) {
                    this.writtenTwiceInMethod.add(xField);
                }
                if (!samePackage) {
                    this.outsidePackage.add(xField);
                }
                if (!initOnly) {
                    this.notFinal.add(xField);
                }
                if (!safeValue) {
                    this.unsafeValue.add(xField);
                }
                if (!this.inStaticInitializer || this.firstFieldUse.containsKey(xField)) break;
                SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction(this);
                this.firstFieldUse.put(xField, sla);
                break;
            }
            case 188: 
            case 189: {
                if (this.zeroOnTOS) {
                    this.emptyArrayOnTOS = true;
                }
                this.zeroOnTOS = false;
                return;
            }
            case 3: {
                this.zeroOnTOS = true;
                this.emptyArrayOnTOS = false;
                return;
            }
        }
        this.zeroOnTOS = false;
        this.emptyArrayOnTOS = false;
    }

    private boolean interesting(XField f) {
        boolean isArray;
        if (!f.isPublic() && !f.isProtected()) {
            return false;
        }
        if (!f.isStatic() || f.isSynthetic() || f.isVolatile()) {
            return false;
        }
        boolean isHashtable = f.getSignature().equals("Ljava/util/Hashtable;");
        boolean bl = isArray = f.getSignature().charAt(0) == '[';
        return !f.isFinal() || isArray || isHashtable;
    }

    public void visit(Field obj) {
        boolean isArray;
        boolean isProtected;
        boolean isVolatile;
        boolean isStatic;
        super.visit(obj);
        int flags = obj.getAccessFlags();
        boolean bl = isStatic = (flags & 8) != 0;
        if (!isStatic) {
            return;
        }
        boolean bl2 = isVolatile = (flags & 0x40) != 0;
        if (isVolatile) {
            return;
        }
        boolean isFinal = (flags & 0x10) != 0;
        boolean isPublic = this.publicClass && (flags & 1) != 0;
        boolean bl3 = isProtected = this.publicClass && (flags & 4) != 0;
        if (!isPublic && !isProtected) {
            return;
        }
        boolean isHashtable = this.getFieldSig().equals("Ljava/util/Hashtable;");
        boolean bl4 = isArray = this.getFieldSig().charAt(0) == '[';
        if (isFinal && !isHashtable && !isArray) {
            return;
        }
        if (this.isEclipseNLS && this.getFieldSig().equals("Ljava/lang/String;")) {
            return;
        }
        this.seen.add(this.getXField());
    }

    public void report() {
        for (XField f : this.seen) {
            String bugType;
            boolean isFinal = f.isFinal();
            String className = f.getClassName();
            String fieldSig = f.getSignature();
            String fieldName = f.getName();
            boolean couldBeFinal = !isFinal && !this.notFinal.contains(f);
            boolean isPublic = f.isPublic();
            boolean couldBePackage = !this.outsidePackage.contains(f);
            boolean movedOutofInterface = false;
            try {
                XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, f.getClassDescriptor());
                movedOutofInterface = couldBePackage && xClass.isInterface();
            }
            catch (CheckedAnalysisException e) {
                // empty catch block
            }
            boolean isHashtable = fieldSig.equals("Ljava/util/Hashtable;");
            boolean isArray = fieldSig.charAt(0) == '[' && this.unsafeValue.contains(f);
            boolean isReadAnywhere = this.readAnywhere.contains(f);
            int priority = 2;
            if (isFinal && !isHashtable && !isArray) continue;
            if (movedOutofInterface) {
                bugType = "MS_OOI_PKGPROTECT";
            } else if (couldBePackage && couldBeFinal && (isHashtable || isArray)) {
                bugType = "MS_FINAL_PKGPROTECT";
            } else if (couldBeFinal && !isHashtable && !isArray) {
                bugType = "MS_SHOULD_BE_FINAL";
                if (this.needsRefactoringToBeFinal.contains(f)) {
                    bugType = "MS_SHOULD_BE_REFACTORED_TO_BE_FINAL";
                }
                if (fieldName.equals(fieldName.toUpperCase()) || fieldSig.charAt(0) == 'L') {
                    priority = 1;
                }
            } else if (couldBePackage) {
                bugType = "MS_PKGPROTECT";
            } else if (isHashtable) {
                bugType = "MS_MUTABLE_HASHTABLE";
                if (!isFinal) {
                    priority = 1;
                }
            } else if (isArray) {
                bugType = "MS_MUTABLE_ARRAY";
                if (fieldSig.indexOf("L") >= 0 || !isFinal) {
                    priority = 1;
                }
            } else if (!isFinal) {
                bugType = "MS_CANNOT_BE_FINAL";
            } else {
                throw new IllegalStateException("impossible");
            }
            if (!isReadAnywhere) {
                priority = 3;
            }
            BugInstance bug = new BugInstance(this, bugType, priority).addClass(className).addField(f);
            SourceLineAnnotation firstPC = this.firstFieldUse.get(f);
            if (firstPC != null) {
                bug.addSourceLine(firstPC);
            }
            this.bugReporter.reportBug(bug);
        }
    }
}

