/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.zipwriter;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.unix.UMask;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

@BridgeMethodsAdded
final class InfoZipUtil {
    public static int createUnixMode(Type type, int permissions) {
        int typeBits = type.getTypeBits() & 0xF;
        return typeBits << 12 | (permissions &= 0xFFF);
    }

    public static ZipExtraField createTimestampField(long timestamp) {
        UnrecognizedExtraField result = new UnrecognizedExtraField();
        result.setHeaderId(new ZipShort(21589));
        ByteBuffer data = ByteBuffer.allocate(5);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)1);
        if ((timestamp /= 1000L) > Integer.MAX_VALUE) {
            timestamp = Integer.MAX_VALUE;
        } else if (timestamp < Integer.MIN_VALUE) {
            timestamp = Integer.MIN_VALUE;
        }
        data.putInt((int)timestamp);
        result.setLocalFileDataData(data.array());
        data = ByteBuffer.allocate(5);
        data.put((byte)1);
        data.putInt((int)timestamp);
        result.setCentralDirectoryData(data.array());
        return result;
    }

    static ZipExtraField createUnixField(int uid, int gid) {
        UnrecognizedExtraField result = new UnrecognizedExtraField();
        result.setHeaderId(new ZipShort(30805));
        ByteBuffer data = ByteBuffer.allocate(4);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.putShort((short)uid);
        data.putShort((short)gid);
        result.setLocalFileDataData(data.array());
        result.setCentralDirectoryData(new byte[0]);
        return result;
    }

    private InfoZipUtil() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static enum Type {
        FILE{

            int getTypeBits() {
                return 8;
            }

            int getDefaultMode(UMask umask) {
                return umask.getMode(438);
            }
        }
        ,
        SYMLINK{

            int getTypeBits() {
                return 10;
            }

            int getDefaultMode(UMask umask) {
                return 511;
            }
        }
        ,
        DIRECTORY{

            int getTypeBits() {
                return 4;
            }

            int getDefaultMode(UMask umask) {
                return umask.getMode(511);
            }
        };


        abstract int getTypeBits();

        abstract int getDefaultMode(UMask var1);
    }
}

