/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.bcp.Variable;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import javax.annotation.Nullable;

public class FieldVariable
implements Variable {
    private final ValueNumber ref;
    private final String className;
    private final String fieldName;
    private final String fieldSig;

    public FieldVariable(String className, String fieldName, String fieldSig) {
        this(null, className, fieldName, fieldSig);
    }

    public FieldVariable(@Nullable ValueNumber ref, String className, String fieldName, String fieldSig) {
        this.ref = ref;
        this.className = className;
        this.fieldName = fieldName;
        this.fieldSig = fieldSig;
    }

    public boolean isStatic() {
        return this.ref == null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldSig() {
        return this.fieldSig;
    }

    public boolean sameAs(Variable other) {
        if (!(other instanceof FieldVariable)) {
            return false;
        }
        FieldVariable otherField = (FieldVariable)other;
        if (this.isStatic() != otherField.isStatic()) {
            return false;
        }
        return (this.ref == null || this.ref.equals(otherField.ref)) && this.className.equals(otherField.className) && this.fieldName.equals(otherField.fieldName) && this.fieldSig.equals(otherField.fieldSig);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.className);
        buf.append('.');
        buf.append(this.fieldName);
        return buf.toString();
    }
}

