/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.interproc.ParameterProperty;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.detect.TrainLongInstantfParams;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Visitor;

public class IntCast2LongAsInstant
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    int lastConstantForSIPUSH;
    TrainLongInstantfParams.LongInstantParameterDatabase database = new TrainLongInstantfParams.LongInstantParameterDatabase();

    public IntCast2LongAsInstant(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        AnalysisContext.currentAnalysisContext().loadPropertyDatabaseFromResource(this.database, "longInstant.db", "long instant database");
    }

    public void sawOpcode(int seen) {
        if (seen == 17) {
            this.lastConstantForSIPUSH = this.getIntConstant();
        }
        if (seen == 185 || seen == 182 || seen == 183 || seen == 184) {
            String signature = this.getSigConstantOperand();
            int numberArguments = PreorderVisitor.getNumberArguments(signature);
            for (int i = 0; i < numberArguments; ++i) {
                ParameterProperty property;
                OpcodeStack.Item item = this.stack.getStackItem(numberArguments - 1 - i);
                if (item.getSpecialKind() != 21 || (property = (ParameterProperty)this.database.getProperty(this.getMethodDescriptorOperand())) == null || !property.hasProperty(i)) continue;
                int priority = 2;
                if (this.getPrevOpcode(1) == 133 && this.getPrevOpcode(2) == 104 && this.getPrevOpcode(3) == 17 && this.lastConstantForSIPUSH == 1000) {
                    priority = 1;
                } else if (this.getPrevOpcode(1) == 133 && this.getPrevOpcode(2) == 104 && this.getPrevOpcode(4) == 17 && this.lastConstantForSIPUSH == 1000) {
                    priority = 1;
                }
                BugInstance bug = new BugInstance(this, "ICAST_INT_2_LONG_AS_INSTANT", priority).addClassAndMethod(this).addCalledMethod(this).addValueSource(item, this).addSourceLine(this);
                this.bugReporter.reportBug(bug);
            }
        }
    }

    public void report() {
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }
}

