/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.swing.JOptionPane;

public class JavaWebStart {
    @CheckForNull
    static final Method jnlpShowDocumentMethod;
    @CheckForNull
    static final Method jnlpGetCodeBaseMethod;
    static final Object jnlpBasicService;

    public static boolean isRunningViaJavaWebstart() {
        return jnlpBasicService != null;
    }

    public static URL resolveRelativeToJnlpCodebase(String s) throws MalformedURLException {
        if (jnlpGetCodeBaseMethod != null) {
            try {
                URL base = (URL)jnlpGetCodeBaseMethod.invoke(jnlpBasicService, new Object[0]);
                if (base != null) {
                    return new URL(base, s);
                }
            }
            catch (RuntimeException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new URL(s);
    }

    static Boolean viaWebStart(URL url) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (jnlpShowDocumentMethod == null) {
            throw new UnsupportedOperationException("Launch via web start not available");
        }
        return (Boolean)jnlpShowDocumentMethod.invoke(jnlpBasicService, url);
    }

    static boolean showViaWebStart(URL url) {
        if (jnlpShowDocumentMethod != null) {
            try {
                Boolean b;
                boolean success;
                if (LaunchBrowser.DEBUG) {
                    JOptionPane.showMessageDialog(null, "Trying browse via webstart");
                }
                boolean bl = success = (b = JavaWebStart.viaWebStart(url)) != null && b != false;
                if (LaunchBrowser.DEBUG) {
                    JOptionPane.showMessageDialog(null, " browse via webstart: " + success);
                }
                return success;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        Method showMethod = null;
        Method getCodeBase = null;
        Object showObject = null;
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            showObject = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            showMethod = showObject.getClass().getMethod("showDocument", URL.class);
            getCodeBase = showObject.getClass().getMethod("getCodeBase", new Class[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        jnlpShowDocumentMethod = showMethod;
        jnlpGetCodeBaseMethod = getCodeBase;
        jnlpBasicService = showObject;
    }
}

