import com.urbancode.air.*
import com.urbancode.air.plugin.findbugs.*;

final def apTool = new AirPluginTool(args[0], args[1])
final def workDir = new File('.').canonicalFile
final def out = System.out

//------------------------------------------------------------------------------
// Execution
//------------------------------------------------------------------------------
final def props                 = apTool.getStepProperties()
final def includes              = props['outputFile']
final def excludes              = props['excludes']
final def reportName            = props['reportName'] ?: 'FindBugs Report'
final def includeDescription    = Boolean.valueOf(props['includeDescription'])
final def onlySummaryCounts     = Boolean.valueOf(props['onlySummaryCounts'])

try {
    def fileSet = new FileSet(workDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    if (includes) {
        println "Reporting on all files in ${includes}"
    }
    if (excludes) {
        println "Excluding files in ${excludes}"
    }
    
    def reportFiles = fileSet.files()
    reportFiles.each { file->
        println 'Report File identified to be included in the FindBugs Report: ' + file
    }
    
    if (reportFiles.size() > 0) {
        def xmlHelper = new FindBugsXmlHelper()
        if (onlySummaryCounts) {
            xmlHelper.uploadSummariesOnly(reportFiles, reportName, includeDescription)
        }
        else {
            xmlHelper.uploadResult(reportFiles, reportName, includeDescription)
        }
    }
    else {
        println 'No report files found to upload'
    }
}
catch (Exception e) {
    println e
    System.exit 1
}
