/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.io.File;
import java.util.Date;
import java.util.regex.Pattern
import java.util.regex.Matcher

public class SCMReview {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    CommandHelper cmdHelper = new CommandHelper(new File('.').canonicalFile)
    String repoUrl;
    String revision;
    String message;
    String labels;
    Integer review;
    boolean submit = false;

    /**
     *
     */
    public void execute() {
        Matcher m = Pattern.compile('ssh://(?:([^@]+)@)?([^/:]+)(?::(\\d+))?/.*').matcher(repoUrl);
        if (!repoUrl.startsWith("ssh://") || !m.matches()) {
            throw new Exception("Gerrit commands must be run over ssh. Could not parse relevant info from $repoUrl");
        }
        String user = m.group(1);
        String host = m.group(2);
        String port = m.group(3);

        String hostWithUser = host;
        if (user) {
            hostWithUser = user + "@" + host;
        }

        def reviewCmd = ['ssh'];
        if (port) {
            reviewCmd << '-p' << port
        }
        reviewCmd << hostWithUser << 'gerrit' << 'review'
        if (message) {
            reviewCmd << '--message'
            reviewCmd << "'$message'" // extra quotes because shell evaluation of argument boundaries over ssh
        }
        if (labels) {
            labels.split(',').each{ label ->
                label = label.trim();
                if (label) {
                    reviewCmd << '--label' << label
                }
            }
        }
        if (review != null) {
            reviewCmd << '--code-review' << review
        }
        if (submit) {
            reviewCmd << '--submit'
        }
        reviewCmd << revision

        cmdHelper.runCommand('Run Gerrit Review Command', reviewCmd);
    }
}