/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.util.Date;

final def workDir = new File('.').canonicalFile
final def out = System.out

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1])

final def stepProps = apTool.getStepProperties();

// Step
final String repoUrl   = stepProps['repoUrl'] ?: ''
final String revision  = stepProps['revision'] ?: ''
final String message   = stepProps['message'] ?: ''
final String labels    = stepProps['labels'] ?: '';
final String review    = stepProps['review'] ?: null;
final String submit    = stepProps['submit'] ?: 'false';

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------

SCMReview step = new SCMReview();
step.repoUrl = repoUrl;
step.revision = revision;
step.message = message;
step.labels = labels;
step.review = review?.toInteger();
step.submit = Boolean.valueOf(submit);
step.execute();