/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.util.Date;

final def workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1])

final def stepProps = apTool.getStepProperties();

// Repo
final String scmCmd     = stepProps['source/repo/commandPath']
final String baseUrl    = stepProps['source/repo/repoBaseUrl']
final String username   = stepProps['source/repo/username']
final String password   = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

// Source
final String srcName            = stepProps['source'];
final File dir                  = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String remoteUrl          = stepProps['source/remoteUrl']
final String branch             = stepProps['source/branch']
final String remoteName         = stepProps['source/remoteName']
final String sourceRevision     = stepProps['source/revision'];
final String userExcludesString = stepProps['source/excludeUsers'] ?: ''
final String fileFiltersString  = stepProps['source/fileFilters'] ?: '';

// Step

// look for date based checkout (buildlife, then actual workspace date)
final Date date         = dateParser.parseDate(stepProps['date']) // this is from actualWorkspaceDate
final Date blDate       = dateParser.parseDate(stepProps['buildlife/workspace.date.$srcName']); // from checkout step
final String blRevision = stepProps["buildlife/workspace.revision.$srcName"];
final String fetchRef   = stepProps["buildlife/workspace.ref.$srcName"]; // optional trigger property for the fetch

// look for revision from step (regular workspace date), then buildlife, then source config

//
// Perform step
//
dir.mkdirs()

SCMCheckout step = new SCMCheckout();
step.directory  = dir;
step.scmCommand = scmCmd;
step.remoteBaseUrl  = baseUrl;
step.remoteUser = username;
step.remotePass = password;
step.remoteUrl  = remoteUrl;
step.remoteName = remoteName;
step.branch     = branch;
step.revision   = blRevision ?: sourceRevision;
step.date       = blDate ?: date;
step.fetchRef   = fetchRef;
step.execute()

if (step.revision) {
    if (blRevision != step.revision) {
        println "Updating workspace revision on buildlife to $step.revision"
        apTool.setOutputProperty("buildlife/workspace.revision.$srcName", step.revision)
        println "";
    }
}
else if (step.date) {
    if (blDate != step.date) {
        println "Updating workspace date on buildlife to $step.date"
        apTool.setOutputProperty("buildlife/workspace.date.$srcName", step.date)
        println "";
    }
}

apTool.storeOutputProperties()
