/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

//--------------------------------------------------------------------------------------------------
// Initialization
//--------------------------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def dateParser = new DateParser()
final def stepProps = apTool.getStepProperties()

//--------------------------------------------------------------------------------------------------
// Repository Properties
//--------------------------------------------------------------------------------------------------
final String scmCmd   = stepProps['source/repo/commandPath'] ?: 'git'
final String baseUrl  = stepProps['source/repo/repoBaseUrl']
final String username = stepProps['source/repo/username']
final String password = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

//--------------------------------------------------------------------------------------------------
// Source Properties
//--------------------------------------------------------------------------------------------------
final String srcName            = stepProps['source'];
final File dir                  = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile
final String remoteUrl          = stepProps['source/remoteUrl']
final String remoteName         = stepProps['source/remoteName']
final String userExcludesString = stepProps['source/excludeUsers'] ?: ''
final String fileFiltersString  = stepProps['source/fileFilters'] ?: ''

//--------------------------------------------------------------------------------------------------
// Step Properties
//--------------------------------------------------------------------------------------------------
final String message       = stepProps['message'] ?: ''
final String label         = stepProps['label'] ?: ''
// look for date based checkout (buildlife, then actual workspace date)
final Date date            = dateParser.parseDate(stepProps['date']) // this is from actualWorkspaceDate
final Date blDate          = dateParser.parseDate(stepProps['buildlife/workspace.date.$srcName'])

//--------------------------------------------------------------------------------------------------
// Buildlife
//--------------------------------------------------------------------------------------------------
final String blRevision = stepProps["buildlife/workspace.revision.$srcName"]

//--------------------------------------------------------------------------------------------------
// Perform Step
//--------------------------------------------------------------------------------------------------
println "Source Name: " + srcName
println "Revision: " + blRevision

dir.mkdirs()

SCMTag step = new SCMTag();
step.directory  = dir;
step.scmCommand = scmCmd;
step.remoteBaseUrl  = baseUrl;
step.remoteUser = username;
step.remotePass = password;
step.remoteUrl  = remoteUrl;
step.remoteName = remoteName;
step.revision   = blRevision;

step.message = message;
step.tagName = label;
step.execute();