/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*

//--------------------------------------------------------------------------------------------------
// Initialization
//--------------------------------------------------------------------------------------------------
final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

//--------------------------------------------------------------------------------------------------
// Repository Properties
//--------------------------------------------------------------------------------------------------
final String scmCmd             = stepProps['source/repo/commandPath'] ?: "git"
final String baseUrl            = stepProps['source/repo/repoBaseUrl']
final String username           = stepProps['source/repo/username']
final String password           = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

//--------------------------------------------------------------------------------------------------
// Source Properties
//--------------------------------------------------------------------------------------------------
final String srcName            = stepProps['source'];
final File dir                  = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile
final String remoteUrl          = stepProps['source/remoteUrl']
final String remoteName         = stepProps['source/remoteName']
final String userExcludesString = stepProps['source/excludeUsers'] ?: ''
final String fileFiltersString  = stepProps['source/fileFilters'] ?: ''

//--------------------------------------------------------------------------------------------------
// Step Properties
//--------------------------------------------------------------------------------------------------
final def startDate            = dateParser.parseDate(stepProps['startDate'])
final def endDate              = dateParser.parseDate(stepProps['endDate'])
final String stepStartRevision = stepProps['startRevision']
final String stepEndRevision   = stepProps['endRevision']
final String changesUrl        = stepProps['changesUrl']
final String stepBranch        = stepProps['source/branch']

//--------------------------------------------------------------------------------------------------
// Buildlife Properties
//--------------------------------------------------------------------------------------------------
final String blBranch        = stepProps["buildlife/workspace.branch.$srcName"]
final String blStartRevision = stepProps["buildlife/startBuildlife/workspace.revision.$srcName"]
final String blEndRevision   = stepProps["buildlife/workspace.revision.$srcName"]

//--------------------------------------------------------------------------------------------------
// Perform Step
//--------------------------------------------------------------------------------------------------
dir.mkdirs()

SCMChangelog step  = new SCMChangelog()
step.directory     = dir;
step.scmCommand    = scmCmd;
step.remoteBaseUrl = baseUrl;
step.remoteUser    = username;
step.remotePass    = password;
step.remoteUrl     = remoteUrl;
step.remoteName    = remoteName;
step.branch        = blBranch ?: stepBranch
step.startRevision = blStartRevision ?: stepStartRevision ?: ''
// For endRevision, the fall back must be to 'HEAD', since changelog --until=${revision} is exclusive
// and therefore we would not get the most recent change.
step.endRevision   = blEndRevision ?: stepEndRevision ?: 'HEAD'
step.startDate     = startDate
step.endDate       = endDate
step.changesUrl    = changesUrl
step.changeSetFilter.setUserExcludes(userExcludesString)
step.changeSetFilter.setFileFilters(fileFiltersString)

step.execute()