/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm.changelog

public class ChangeSet {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    String id= null;
    String user = null;
    String message = null;
    Date date = null;
    final List<ChangeSetFileEntry> fileSet = [];
    Map<String,String> properties = new LinkedHashMap();

    /**
     * Determine if the change contains only excluded file paths.
     * (an empty fileset will be included)
     *
     * @param changeSetFilter
     * @return
     */
    public boolean hasAllowedPath(ChangeSetFilter changeSetFilter) {
        return !fileSet || fileSet.find{ changeSetFilter.pathIsIncluded(it.path) } != null;
    }

    public boolean hasAllowedAuthor(ChangeSetFilter changeSetFilter) {
        return changeSetFilter.authorIsIncluded(user);
    }
}
