package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.io.File;
import java.util.Date;

public class SCMTag extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    String tagName
    String message

    /**
     *
     */
    public void execute() {
        final def cmdHelper = new CommandHelper(directory);

        assert tagName : 'Tag Name is a required attribute'
        assert scmCommand : 'Message is a required attribute'
        assert revision: 'Can not determine revision to tag'

        // create tag in local repo
        def tagCommand = [scmCommand, '--no-pager', 'tag', '-m', message, tagName, revision];
        cmdHelper.runCommand('Creating Tag', tagCommand);

        // Immediately Push to remote
        // WARN: if http prompts for authentication this will hang!
        def pushCommand = [scmCommand, '--no-pager', 'push', remoteName, 'tag', tagName];
        cmdHelper.runCommand('Pushing Tag', pushCommand);
    }
}
