#!/usr/bin/env groovy

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def outProps = new Properties();

final def scriptBody = props['scriptBody']

try {
    Binding binding = new Binding();
    binding.setVariable("outProps", outProps);
    binding.setVariable("inProps", props);
    GroovyShell shell = new GroovyShell(binding);

    shell.evaluate(scriptBody);
}
finally {
    if (inputPropsFile != null) {
        inputPropsFile.delete()
    }
}

// write out props set by script
final def outputPropsFile = new File(args[1]);
try {
    def outputPropsStream = new FileOutputStream(outputPropsFile);
    outProps.store(outputPropsStream, "Output props");
}
catch (IOException e) {
    throw new RuntimeException("Could not write the output propertes!", e);
}
