#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

final def workDir = new File('.').canonicalFile
final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties()
final CommandHelper cmdHelper = new CommandHelper(workDir);

final def scriptBody = props['scriptBody']
final def groovyHome = props['groovyHome']
assert groovyHome
cmdHelper.removeEnvironmentVariable("GROOVY_HOME")

def script = """
final def inProps = new Properties()
final def outProps = new Properties();

{ ->
    final def inputPropsFile = new File(args[0])
    try {
        inputPropsStream = new FileInputStream(inputPropsFile)
        inProps.load(inputPropsStream)
    }
    catch (IOException e) {
        throw new RuntimeException(e)
    }
}()

${scriptBody};

{ ->
    // write out props set by script
    final def outputPropsFile = new File(args[1])
    try {
        def outputPropsStream = new FileOutputStream(outputPropsFile)
        outProps.store(outputPropsStream, "Output props")
    }
    catch (IOException e) {
        throw new RuntimeException("Could not write the output properties!", e)
    }
}()
"""

File scriptFile = File.createTempFile("groovy_script_", ".groovy")
scriptFile.text = script

try {
    def command = ["${groovyHome}/bin/groovy", scriptFile, args[0], args[1]]
    cmdHelper.runCommand("Running Groovy Script", command)
}
finally {
    scriptFile.delete()
}
