import com.urbancode.air.*

final def workDir = new File('.').canonicalFile
final def out = System.out

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
CommandHelper commandHelper = new CommandHelper(workDir)

final def commandPath = props['automation/commandPath'] ? props['automation/commandPath'] + File.separator : ''

final def buildId = props['buildId']
final def buildOptions = props['buildOptions']
final def javaMemorySetting = props['javaMemorySetting']
final def analyzerOptions = props['analyzerOptions']?.split('[ \n\r]')?.findAll{ it && it.trim().length() > 0}

def buildOptionsList = buildOptions.tokenize("\n")

def commandLine = [commandPath + 'sourceanalyzer', '-b', buildId]

if (analyzerOptions) {
    analyzerOptions.each { option ->
        commandLine << option
    }
}
if (javaMemorySetting) {
    commandLine << javaMemorySetting
}

buildOptionsList.each { option ->
    commandLine << option
}

commandHelper.runCommand("Running build with Fortify", commandLine)