package com.urbancode.air.plugin.fortify

import org.xml.sax.*

class FortifyHandler extends helpers.DefaultHandler {
    
    def findingId
    def findingFile
    def findingLine
    def findingName
    def findingSeverity
    def findingDesc = ''
    def findingStatus = ''
    def addFinding
    def sb

    FortifyHandler(def addFinding) {
        this.addFinding = addFinding
    }

    void startElement(String ns, String localName, String qName, Attributes attribs) {
        sb = new StringBuilder()
        
        switch (qName) {
        
            case 'SourceLocation':
                if (!findingFile) findingFile = attribs.getValue('path')
                if (!findingLine) findingLine = attribs.getValue('line')
                break
        }
    }

    void characters(char[] ch, int start, int length) {
        sb.append(ch, start, length)
    }

    void endElement(String ns, String localName, String qName) {
        switch (qName) {

            case 'InstanceID':
                findingId = sb.toString()
                break
                
            case 'Type':
                findingName = sb.toString()
                break

            case 'Subtype':
                findingName += ' - ' + sb.toString()
                break

            case 'InstanceSeverity':
                findingSeverity = sb.toString()
                break

            case 'Vulnerability':
                addFinding(findingId, findingFile, findingLine, findingName, findingSeverity, findingDesc, findingStatus)
                findingFile = null
                findingLine = null
                break
        }
    }
}